% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_migration_ABC.R
\name{estimate_migration_ABC}
\alias{estimate_migration_ABC}
\title{Estimates migration parameters using an ABC method.}
\usage{
estimate_migration_ABC(
  migr,
  estimate_transitions = TRUE,
  estimate_sojourns = TRUE,
  sojourn_domain = NULL,
  nb_simul = 1000,
  only_likelihood = FALSE,
  p_acc_min = 0.05,
  choice_method = "mode",
  venter_bw = 0.2,
  n_cluster = 1,
  verbose = TRUE
)
}
\arguments{
\item{migr}{A migration structure. Required migration fields are: 
site_name, link_knowledge, flight_duration, initial_state, horizon, 
death_probability, observations. Field transition_law_param is also required 
if the attribute estimate_transitions is set to FALSE. Field 
sojourn_law_param is also required if the attribute estimate_sojourns 
contains boolean values set to FALSE.}

\item{estimate_transitions}{If TRUE, transitions probabilities are estimated.
Default value is TRUE.}

\item{estimate_sojourns}{Vector of boolean, identifies sites for which 
mean sojourn times must be estimated. Default value is TRUE transformed in 
TRUE for every site except for the last one (no need to estimate sojourn duration
on the last site which is an arrival site).}

\item{sojourn_domain}{Range (min and max) of the sojourn time parameters.
Possible values:
 (i) NULL, all intervals are set to [0, migr$horizon],
 (ii) vector of 2 values min and max then all domains are [min, max] interval,
 (iii) list of interval for each site.
Note that are taken into account only intervals for sites with TRUE in estimate_sojourn arguments.
Default value is  NULL.}

\item{nb_simul}{Number of simulations divided by 2 to return in the 
posterior distribution (see Lenormand method). A positive integer. Default value is 1000.}

\item{only_likelihood}{Boolean. If TRUE, the vector of 
statistics in ABC is composed of this log likelihood only. If FALSE, the 
vector of statistics is composed of the full matrix (site*time)
of simulated observations. Default is FALSE.}

\item{p_acc_min}{The Lenormand method parameter. A positive number between 0 and 1 (strictly). 
This is the stopping criterion of the algorithm: a small number ensures a better convergence 
of the algorithm, but at a cost in computing time.  Default value is 0.05.}

\item{choice_method}{Name of method (in "mode", "mean", "median","density") to choose parameters
from ABC distribution. Default is "mode".}

\item{venter_bw}{if choice_method is "mode", the bandwidth in [0, 1] to be used 
with the modeest::venter method. Default value is 0.2.}

\item{n_cluster}{The number of cores used for simulation. Default value is 1.}

\item{verbose}{If TRUE, display iterations achievement. Default is TRUE.}
}
\value{
The migration structure given with a new attribute 
\emph{estimation_method} which is a structure with 3 attributes:

              . \emph{name} = "ABC",

              . \emph{settings}, a structure with attributes:
                   estimate_transitions,
                   estimate_sojourns, 
                   sojourn_domain, \cr
                   nb_simul,
                   only_likelihood,
                   p_acc_min,
                   choice_method,
                   venter_bw,
                   n_cluster, 

              . \emph{output}, a structure with attributes:
              
                   - transition_law_param: estimated transition parameters,
                   
                   - sojourn_law_param: estimated sojourn parameters,
                   
                   - log_ABC: see EasyABC::ABC_sequential documentation 
                     for attributes param, stats, stats_normalization, weigths, 
                     epsilon, nsim, computime,
                   
                   - log_param_dist: distribution of free estimated parameters 
                     (dataframe size nb_simul/2 x number of estimated free parameters),
                   
                   - log_param_def: free parameters estimated with their initial values.
}
\description{
Estimates migration parameters using an ABC (Approximate Bayesian Approach) method.
Use the Lenormand method  (ABC_sequential method) from the EasyABC package.
}
\examples{
migr <- generate_toy_migration()
# Argument nb_simul just provide to reduce running time
estimated_migr <- estimate_migration_ABC( migr, nb_simul = 30 ) 
print( estimated_migr$estimation_method$output$transition_law_param )
estimated_migr <- estimate_migration_ABC( migr, nb_simul = 40 , sojourn_domain = c(2,4), 
                                         estimate_sojourns = c(TRUE, TRUE, TRUE, FALSE, FALSE))
print( estimated_migr$estimation_method$output$transition_law_param )
}
