% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctf_tools.R
\name{ctf_tools}
\alias{ctf_tools}
\title{Cross-temporal reconciliation tools}
\usage{
ctf_tools(C, m, h = 1, Ut, nb, Sstruc = FALSE)
}
\arguments{
\item{C}{(\code{na x nb}) cross-sectional (contemporaneous) matrix mapping the bottom
level series into the higher level ones.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order of
temporal aggregation).}

\item{h}{Forecast horizon for the lowest frequency (most temporally aggregated) time
series (\emph{default} is \code{1}).}

\item{Ut}{Zero constraints cross-sectional (contemporaneous) kernel matrix
\eqn{(\textbf{U}'\textbf{Y} = \mathbf{0})}{} spanning the null space valid for the reconciled
forecasts. It can be used instead of parameter \code{C}, but in this case \code{nb} (n = na + nb) is needed. If
the hierarchy admits a structural representation, \code{Ut} has dimension (\code{na x n}).}

\item{nb}{Number of bottom time series; if \code{C} is present, \code{nb} is not used.}

\item{Sstruc}{If \code{Sstruc = TRUE} the function returns also the structural representation matrix of
a cross-temporal system (\emph{default} is \code{FALSE}).}
}
\value{
\strong{ctf} list with:
\item{\code{Ht}}{Full row-rank cross-temporal zero-valued constraints (kernel)
matrix\eqn{,\; \textbf{H}'\textbf{y} = \mathbf{0}}{}.}
\item{\code{Htbreve}}{Complete, not full row-rank cross-temporal zero-valued
constraints (kernel) matrix.}
\item{\code{Htstruc}}{Zero constraints full row-rank cross-temporal kernel matrix
(structural representation) \eqn{,\; \check{\textbf{H}}'}{}.}
\item{\code{Sstruc}}{Cross-temporal summing matrix (structural
representation)\eqn{,\; \check{\textbf{S}}}{}.}

\strong{hts} list from \code{\link{hts_tools}}

\strong{thf} list from \code{\link{thf_tools}}
}
\description{
Some useful tools for the cross-temporal forecast reconciliation of cross-sectionally and
temporally constrained time series
}
\examples{
# One level hierarchy (na = 1, nb = 2) with quarterly data
obj <- ctf_tools(C = matrix(c(1, 1), 1), m = 4, Sstruc = TRUE)
}
\keyword{utilities}
