% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/octrec.R
\name{octrec}
\alias{octrec}
\title{Optimal combination cross-temporal forecast reconciliation}
\usage{
octrec(basef, m, C, comb, res, Ut, nb, W, Sstruc,
       mse = TRUE, corpcor = FALSE, type = "M", sol = "direct",
       nn = FALSE, keep = "list",
       settings = osqpSettings(verbose = FALSE, eps_abs = 1e-5,
       eps_rel = 1e-5, polish_refine_iter = 100, polish=TRUE))
}
\arguments{
\item{basef}{(\code{n x h(k* + m)}) matrix of base forecasts to be reconciled;
\code{n} is the total number of variables, \code{m} is the highest frequency,
\code{k*} is the sum of (\code{p-1}) factors of \code{m}, excluding \code{m},
and \code{h} is the forecast horizon. Each row identifies, a time series, and the forecasts
are ordered as [lowest_freq' ...  highest_freq']'.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order of temporal aggregation).}

\item{C}{(\code{na x nb}) cross-sectional (contemporaneous) matrix mapping the bottom
level series into the higher level ones.}

\item{comb}{Type of the reconciliation, it corrispond to a different covariance
matrix (\code{n(k* + m) x n(k* + m)}), \code{k*} is the sum of (\code{p-1})
factors of \code{m} (exclude \code{m} as factors) and \code{n} is the number
of variables:
\itemize{
  \item \bold{ols} (Identity);
  \item \bold{struc} (Cross-temporal summing matrix, use the \code{Sstruc} param to reduce computation time);
  \item \bold{wlsh} (Hierarchy variances matrix);
  \item \bold{wlsv} (Series variances matrix);
  \item \bold{bdshr} (Shrunk cross-covariance matrix, cross-sectional framework);
  \item \bold{bdsam}  (Sample cross-covariance matrix, cross-sectional framework);
  \item \bold{acov} (Series auto-covariance matrix);
  \item \bold{Sshr} (Series shrunk cross-covariance matrix);
  \item \bold{Ssam} (Series cross-covariance matrix);
  \item \bold{shr}  (Shrunk cross-covariance matrix);
  \item \bold{sam} (Sample cross-covariance matrix);
  \item \bold{w} use your personal matrix W in param \code{W}.
}}

\item{res}{(\code{n x N(k* + m)}) matrix containing the residuals at all the
temporal frequencies ordered [lowest_freq' ...  highest_freq']' (columns) for
each variable (row), needed to estimate the covariance matrix when \code{comb =}
 \code{\{"sam",} \code{"wlsv",} \code{"wlsh",} \code{"acov",} \code{"Ssam",}
 \code{"Sshr",} \code{"Sshr1",} \code{"shr"\}}.}

\item{Ut}{Zero constraints cross-sectional (contemporaneous) kernel matrix
\eqn{(\textbf{U}'\textbf{Y} = \mathbf{0})}{} spanning the null space valid for the reconciled
forecasts. It can be used instead of parameter \code{C}, but in this case \code{nb} (n = na + nb) is needed. If
the hierarchy admits a structural representation, \code{Ut} has dimension (\code{na x n}).}

\item{nb}{Number of bottom time series; if \code{C} is present, \code{nb} is not used.}

\item{W}{This option permits to directly enter the covariance matrix:
\enumerate{
  \item \code{W} must be a p.d. (\code{n(k* + m) x n(k* + m)}) matrix;
  \item if \code{comb} is different from "\code{w}", \code{W} is not used.
}}

\item{Sstruc}{Cross-temporal summing matrix (structural representation)\eqn{,\; \check{\textbf{S}}}{};
can be obtained through the function \link[FoReco]{ctf_tools}.}

\item{mse}{Logical value: \code{TRUE} (\emph{default}) calculates the
covariance matrix of the in-sample residuals (when necessary) according to the original
\pkg{hts} and \pkg{thief} formulation: no mean correction, T as denominator.}

\item{corpcor}{Logical value: \code{TRUE} if \pkg{corpcor} (\enc{Schäfer}{Schafer} et
al., 2017) must be used to shrink the sample covariance matrix according to
\enc{Schäfer}{Schafer} and Strimmer (2005), otherwise the function uses the same
implementation as package \pkg{hts}.}

\item{type}{Approach used to compute the reconciled forecasts: \code{"M"} for
the projection approach with matrix M (\emph{default}), or \code{"S"} for the
structural approach with summing matrix S.}

\item{sol}{Solution technique for the reconciliation problem: either \code{"direct"} (\emph{default}) for the direct
solution or \code{"osqp"} for the numerical solution (solving a linearly constrained quadratic
program using \code{\link[osqp]{solve_osqp}}).}

\item{nn}{Logical value: \code{TRUE} if non-negative reconciled forecasts are wished.}

\item{keep}{Return a list object of the reconciled forecasts at all levels.}

\item{settings}{Settings for \pkg{osqp} (object \code{\link[osqp]{osqpSettings}}). The default options
are: \code{verbose = FALSE}, \code{eps_abs = 1e-5}, \code{eps_rel = 1e-5},
\code{polish_refine_iter = 100} and \code{polish = TRUE}. For details, see the
\href{https://osqp.org/}{\pkg{osqp} documentation} (Stellato et al., 2019).}
}
\value{
If the parameter \code{keep} is equal to \code{"recf"}, then the function
returns only the (\code{n x h(k* + m)}) reconciled forecasts matrix, otherwise (\code{keep="all"})
it returns a list that mainly depends on what type of representation (\code{type})
and methodology (\code{sol}) have been used:
\item{\code{recf}}{(\code{n x h(k* + m)}) reconciled forecasts matrix.}
\item{\code{Omega}}{Covariance matrix used for reconciled forecasts (\code{vec}(\code{Y}\enc{'}{'}) representation).}
\item{\code{W}}{Covariance matrix used for reconciled forecasts (\code{vec(Y)} representation).}
\item{\code{nn_check}}{Number of negative values (if zero, there are no values below zero).}
\item{\code{rec_check}}{Logical value: has the hierarchy been respected?}
\item{\code{M} (\code{type="M"} and \code{type="direct"})}{Projection matrix (projection approach).}
\item{\code{G} (\code{type="S"} and \code{type="direct"})}{Projection matrix (structural approach).}
\item{\code{S} (\code{type="S"} and \code{type="direct"})}{Cross-temporal summing matrix\eqn{, \; \textbf{Q}\check{\textbf{S}}}{} (\code{vec}(\code{Y}\enc{'}{'}) representation).}
\item{\code{info} (\code{type="osqp"})}{matrix with some useful indicators (columns)
for each forecast horizon \code{h} (rows): run time (\code{run_time}) number of iteration,
norm of primal residual (\code{pri_res}), status of osqp's solution (\code{status}) and
polish's status (\code{status_polish}).}
}
\description{
Optimal (in least squares sense) combination cross-temporal forecast reconciliation.
The reconciled forecasts are calculated either through a projection approach
(Byron, 1978), or the equivalent structural approach by Hyndman et al. (2011).
}
\details{
In case of non-negativity constraints, there are two ways:
\enumerate{
  \item \code{sol = "direct"} and \code{nn = TRUE}: the base forecasts
  will be reconciled at first without non-negativity constraints, then, if negative reconciled
  values are present, the \code{"osqp"} solver is used.
  \item \code{sol = "osqp"} and \code{nn = TRUE}: the base forecasts will be
  reconciled through the \code{"osqp"} solver.
}
}
\examples{
data(FoReco_data)
obj <- octrec(FoReco_data$base, m = 12, C = FoReco_data$C,
              comb = "bdshr", res = FoReco_data$res)

}
\references{
Byron, R.P. (1978), The estimation of large social accounts matrices,
\emph{Journal of the Royal Statistical Society A}, 141, 3, 359-367.

Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.

\enc{Schäfer}{Schafer}, J.L., Opgen-Rhein, R., Zuber, V., Ahdesmaki, M.,
Duarte Silva, A.P., Strimmer, K. (2017), \emph{Package `corpcor'}, R
package version 1.6.9 (April 1, 2017), \href{https://CRAN.R-project.org/package=corpcor}{https://CRAN.R-project.org/package= corpcor}.

\enc{Schäfer}{Schafer}, J.L., Strimmer, K. (2005), A Shrinkage Approach to Large-Scale Covariance
Matrix Estimation and Implications for Functional Genomics, \emph{Statistical
Applications in Genetics and Molecular Biology}, 4, 1.

Stellato, B., Banjac, G., Goulart, P., Bemporad, A., Boyd, S. (2018). OSQP:
An Operator Splitting Solver for Quadratic Programs, \href{https://arxiv.org/abs/1711.08013}{arXiv:1711.08013}.

Stellato, B., Banjac, G., Goulart, P., Boyd, S., Anderson, E. (2019), OSQP:
Quadratic Programming Solver using the 'OSQP' Library, R package version 0.6.0.3
(October 10, 2019), \href{https://CRAN.R-project.org/package=osqp}{https://CRAN.R-project.org/package=osqp}.
}
\keyword{reconciliation}
