% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualsfun.R
\name{residuals_matrix}
\alias{residuals_matrix}
\title{Arrange temporal and cross-temporal residuals in a matrix form}
\usage{
residuals_matrix(res, m)
}
\arguments{
\item{res}{(\mjseqn{n \times N(k^\ast + m)}) matrix or (\mjseqn{N(k^\ast + m)})
vector containing the residuals at all the temporal frequencies
ordered [lowest_freq' ...  highest_freq']'.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \mjseqn{m}), or a subset of \mjseqn{p} factors
of \mjseqn{m}.}
}
\value{
a (\mjseqn{N \times n(k^\ast + m)}) matrix
(if the input res is a vector then \mjseqn{n = 1})
}
\description{
Arrange temporal and cross-temporal residuals in a matrix form
}
\examples{
data(FoReco_data)
mat <- residuals_matrix(FoReco_data$res, m = 12)

}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{agg_ts}()},
\code{\link{arrange_hres}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{lcmat}()},
\code{\link{oct_bounds}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()},
\code{\link{thf_tools}()}
}
\concept{utilities}
