% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{cstools}
\alias{cstools}
\title{Cross-sectional reconciliation tools}
\usage{
cstools(agg_mat, cons_mat, sparse = TRUE)
}
\arguments{
\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{cons_mat}{A (\eqn{n_a \times n}) numeric matrix representing the cross-sectional
zero constraints. It spans the null space for the reconciled forecasts.}

\item{sparse}{Option to return sparse matrices (\emph{default} is \code{TRUE}).}
}
\value{
A list with four elements:
\item{dim}{A vector containing information about the number of series for the complete
system (\code{n}), for upper levels (\code{na}) and bottom level (\code{nb}).}
\item{agg_mat}{The cross-sectional aggregation matrix.}
\item{strc_mat}{The cross-sectional structural matrix.}
\item{cons_mat}{The cross-sectional zero constraints matrix.}
}
\description{
Some useful tools for the cross-sectional forecast reconciliation of a
linearly constrained (e.g., hierarchical/grouped) multiple time series.
}
\examples{
# Cross-sectional framework
# One level hierarchy A = [1 1]
A <- matrix(1, 1, 2)
obj <- cstools(agg_mat = A)

}
\seealso{
Cross-sectional framework: 
\code{\link{csboot}()},
\code{\link{csbu}()},
\code{\link{cscov}()},
\code{\link{cslcc}()},
\code{\link{csmo}()},
\code{\link{csrec}()},
\code{\link{cstd}()}

Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{shrink_estim}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Framework: cross-sectional}
\concept{Utilities}
