# license GPL-3
# This file is part of the R-package ForestElementsR.
#
# ForestElementsR is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# ForestElementsR is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ForestElementsR.  If not, see <https://www.gnu.org/licenses/>.




#' Yield Tables
#'
#' @description The yield table system of **ForestElementsR** allows easy use
#' of yield tables that are available as an \code{\link{fe_yield_table}} object.
#' Here, we list all yield tables that come with the current version of the
#' package. For test purposes and as an example, the Scots Pine table by
#' Wiedemann (1943) is provided as a raw data frame (prefix "ytable_") and an
#' \code{fe_yield_table} object (prefix "fe_ytable_"). The raw data frame can be
#' transformed into a \code{fe_yield_table} object with the function
#' \code{\link{fe_yield_table}} (see the example there).
#' When we refer to *Schober's yield table collection* below, we mean
#' \insertCite{ertragstafeln_schober_1975;textual}{ForestElementsR}. Many of
#' the yield tables listed were implemented in the version published in what we
#' refer to as the *Hilfstafeln edited by the Bavarian Forest Administration*.
#' Hereby, we mean, more precisely,
#' \insertCite{hilfstafeln_bavaria_1990;textual}{ForestElementsR}, and
#' \insertCite{hilfstafeln_bavaria_2018;textual}{ForestElementsR}. The yield
#' table collection in both editions is almost identical, and represented
#' in  **ForestElementsR** (including error corrections beyond the 2018
#' edition). Only the yield table by Kenk and Hradetzky for Douglas fir that is
#' new in the 2018 hasn't been imported here, yet.
#'
#' The following yield tables are currently implemented (alphabetically ordered
#' by author names):
#'
#' \itemize{
#'  \item{*Assmann-Franz 1963, Norway Spruce, Mean Yield Level*: Imported from
#'  the "Hilfstafeln" edited by the Bavarian Forest Administration. The total
#'  volume production (tvp), mean annual increment (mai), and the periodic
#'  annual increment were given as reduced values (under bark, harvest losses
#'  substracted) only. Thus, they were converted into standing m³ over bark
#'  by dividing them by 0.81 (standard factor for Norway spruce in Bavaria). The
#'  yield table allows site indexing based on the dominant height h100, and the
#'  quadratic mean height hq, whereby the former is the way Ernst Assmann and
#'  Friedrich Franz had in mind. The site index of this table is, unusual for
#'  German yield tables, given as a stand's expected dominant height at an age
#'  of 100 years. Unlike in most yield table, the number of removal trees
#'  (n_rmv_ha), the volume of the removal stand (v_rmv_ha), and the periodic
#'  annual increment (pai_m3_ha_yr, red_m3_ha_yr) relate to the subsequent, not
#'  the previous time span. Variables whose names begin with "red_" relate to
#'  harvested volume under bark; i.e. reduced by 19 % which takes into account
#'  both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Bauer, 1955, Red Oak*: Imported from the "Hilfstafeln" edited by the
#'  Bavarian Forest Administration. In the source files, the quadratic mean
#'  height of the site index classes was only available as lower threshold
#'  (i.e 1/4 site index lower). So the original heights were taken from the
#'  version published in Schober's (1975) yield table collection for the whole
#'  site indexes (I.0, II.0, etc.). The values for the site indexes I.5 and II.5
#'  were generated by linear inter- and extrapolation. The total volume
#'  production was not contained in the Bavarian edition of the table; so, it
#'  was added from the version published in Schober's (1975) collection.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 21 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Blume, 1949, Poplar*: Imported from the "Hilfstafeln" edited
#'  by the Bavarian Forest Administration. Originally, this table was designed
#'  for site indexing by quadratic mean diameter (d_q_cm), not by height.
#'  Therefore, this diameter was given in the table as lower threshold, here
#'  listed as "d_q_cm_si_plus_025". As site indexing by height is always
#'  preferable, options for site indexing by both, diameter and height, were
#'  included in the fe_yield_table representation of this table.
#'  The actual quadratic mean diameter (d_q_cm) which is used for site indexing
#'  if the user decides so was calculated from dividing the given basal area
#'  by the stem number, multiplying it with 4/pi, and taking the square root of
#'  the result. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  Despite the lower diameter threshold for site indexing, the table follows
#'  the standard structure of all tables that are part of the Bavarian
#'  "Hilfstafeln": Stem number, mean diameter, standing volume, and basal area
#'  describe the remaining stand. Wood volume means is defined as standing
#'  coarse wood over bark. Variables whose names begin with "red_" relate to
#'  harvested volume under bark; i.e. reduced by 19 % which takes into account
#'  both, harvest losses (mainly stump) and bark volume.
#'  Overall, this table seems not really well constructed, the time-curves of
#'  its variables are often not intuitively plausible. Some inconsistencies
#'  (e.g. decreasing tvp resulting from a to low mean annual increment value)
#'  were corrected.}
#'
#'  \item{*Gehrhardt, 1908, European Beech, Moderate Thinning*:Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 15.4 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume. The
#'  quadratic mean diameter (d_q_cm) for site index 2.0 was obviously wrong
#'  in the source data. It was corrected by interpolation.}
#'
#'  \item{*Gehrhardt 1921, Norway Spruce, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 19 % which takes into
#'  account both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Gehrhardt, 1921, Scots Pine, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 21 % which takes into
#'  account both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Guttenberg, 1915, Norway Spruce, High Mountains*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 19 % which takes into
#'  account both, harvest losses (mainly stump) and bark volume.
#'  The interpolated site indexes contained many mistakes (highlighted in the
#'  source data), mostly in the mai which could, however, be easily corrected
#'  by interpolation between the adjacent site index tables.}
#'
#'  \item{*Hausser 1956, Silver Fir, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. In the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights were taken from the version published in Schober's (1975) yield
#'  table collection for the whole site indexes (I.0, II.0, etc.). The values
#'  for the site indexes I.5, II.5, etc. were generated by linear inter- and
#'  extrapolation. The total volume production was not contained in the
#'  Bavarian edition of the table; so, it was added from the version published
#'  in Schober's (1975) collection.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 19 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Juettner 1955, Oak, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. In the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights were taken from the version published in Schober's (1975) yield
#'  table collection for the whole site indexes (I.0, II.0, etc.). The values
#'  for the site indexes I.5, II.5, etc. were generated by linear inter- and
#'  extrapolation. The total volume production was not contained in the
#'  Bavarian edition of the table; so, it was added from the version published
#'  in Schober's (1975) collection.}
#'
#'  \item{*Mitscherlich, 1945, Black Alder*:  Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 19 % which takes into
#'  account both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Schober 1946, European Larch, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights were taken from the version published in Schober's (1975) yield
#'  table collection for the whole site indexes (I.0, II.0, etc.). The values
#'  for the site indexes I.5, II.5, etc. were generated by linear inter- and
#'  extrapolation. The total volume production was not contained in the
#'  Bavarian edition of the table; so, it was added from the version published
#'  in Schober's (1975) collection.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 28 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume.
#'  There were some mistakes in the mean diameters and basal areas of the
#'  interpolated site index tables I.5 (most) and II.5 (less). These have been
#'  corrected by interpolating between the original values of the integer site
#'  index tables (I.0, II.0, III.0).}
#'
#'  \item{*Schober, 1953, Japanese Larch, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. In the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights were taken from the version published in Schober's (1975) yield
#'  table collection for the whole site indexes (I.0, II.0, etc.). The values
#'  for the site index I.5 were generated by linear inter- and extrapolation.
#'  The total volume production was not contained in the Bavarian edition of the
#'  table; so, it was added from the version published in Schober's (1975)
#'  collection.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 28 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Schober 1956, Douglas Fir, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 21 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume.}
#'
#'  \item{*Schwappach, 1903/29, Birch*: Imported from the "Hilfstafeln" edited
#'  by the Bavarian Forest Administration. In the source files, the quadratic
#'  mean height of the site index classes was only available as lower threshold
#'  (i.e 1/4 site index lower). So the original heights were taken from the
#'  version published in Schober's (1975) yield table collection for the whole
#'  site indexes (I.0, II.0, etc.). The values for the site indexes I.5 and II.5
#'  were generated by linear inter- and extrapolation. The total volume
#'  production was not contained in the Bavarian edition of the table; so, it
#'  was added from the version published in Schober's (1975) collection.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 19 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume. An
#'  obvious interpoliation error was corrected (site index 1.5, basal area at
#'  age = 40 years).}
#'
#'  \item{*Vanselow, 1951, Norway Spruce, Southern Bavaria*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 19 % which takes into
#'  account both, harvest losses (mainly stump) and bark volume.
#'  Two values, basal area at age 20 and standing volume at age 40 for site
#'  index I.5 were obviously wrong, probably due to interpolation errors. Both
#'  values were replaced by those obtained from correct interpolation between
#'  site indexes I and II.}
#'
#'  \item{*Wiedemann 1931, European Beech, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights, as required for automated use were generated by inter- and
#'  extrapolation. The total volume production (tvp) was not contained in the
#'  Bavarian edition of the table. Therefore, it was re-calculated by
#'  multiplying the table's mean annual increment (mai) with the stand age.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 15.4 % which takes
#'  into account both, harvest losses (mainly stump) and bark volume.
#'  Site index I.5, age 130: Mistake in n_ha, value 465 was wrong. Linearly
#'  interpolated from the neighboring values to 238.5.}
#'
#'  \item{*Wiedemann 1936/42, Norway Spruce, Moderate Thinning*: Imported from
#'  the "Hilfstafeln" edited by the Bavarian Forest Administration. in the
#'  source files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights were taken from the version published in Schober's (1975) yield
#'  table collection for the whole site indexes (I.0, II.0, etc.). The values
#'  for the site indexes I.5, II.5, etc. were generated by linear inter- and
#'  extrapolation. The total volume production was not contained in the
#'  Bavarian edition of the table; so, it was added from the version published
#'  in Schober's (1975) collection.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 19 % which takes into
#'  account both, harvest losses (mainly stump) and bark volume.
#'  Several mistakes were found in the source files, especially consistently
#'  wrong stem numbers and mean diameters in site indexes 4 and 5.}
#'
#'  \item{*Wiedemann 1943, Scots Pine, Moderate Thinning*: Imported from the
#'  "Hilfstafeln" edited by the Bavarian Forest Administration. in the source
#'  files, the quadratic mean height of the site index classes was only
#'  available as lower threshold (i.e 1/4 site index lower). So the original
#'  heights were taken from the version published in Schober's (1975) yield
#'  table collection for the whole site indexes (I.0, II.0, etc.). The values
#'  for the site indexes I.5, II.5, etc. were generated by linear inter- and
#'  extrapolation. The total volume production was not contained in the
#'  Bavarian edition of the table; so, it was added from the version published
#'  in Schober's (1975) collection.
#'  The table follows the standard structure of all tables that are part of the
#'  Bavarian "Hilfstafeln": Stem number, mean diameter, standing volume, and
#'  basal area describe the remaining stand. Wood volume means is defined as
#'  standing coarse wood over bark. Variables whose names begin with "red_"
#'  relate to harvested volume under bark; i.e. reduced by 21 % which takes into
#'  account both, harvest losses (mainly stump) and bark volume.
#'  The Bavarian original values had a mistake in N/ha, site index I.0, age 95:
#'  343 (wrong) instead of 373 (right), correct value was taken from the version
#'  in Schober's (1975) yield table collection.}
#'
#'  \item{*Wimmenauer-Schwappach, 1919/29, Ash, Weak Thinning*: Imported from
#'  the "Hilfstafeln" edited by the Bavarian Forest Administration. The table
#'  follows the standard structure of all tables that are part of the Bavarian
#'  "Hilfstafeln": Stem number, mean diameter, standing volume, and basal area
#'  describe the remaining stand. Wood volume is defined as standing
#'  coarse wood over bark. Variables whose names begin with "red_" relate to
#'  harvested volume under bark; i.e. reduced by 19 % which takes into account
#'  both, harvest losses (mainly stump) and bark volume.}
#' }
#'
#'
#' @references
#'   \insertAllCited{}
#'
#'
#' @name yield_tables
NULL

#' @rdname yield_tables
"fe_ytable_spruce_assmann_franz_mean_yield_level_1963"

#' @rdname yield_tables
"fe_ytable_poplar_blume_1949"

#' @rdname yield_tables
"fe_ytable_redoak_bauer_1955"

#' @rdname yield_tables
"fe_ytable_beech_gehrhardt_moderate_1908"

#' @rdname yield_tables
"fe_ytable_spruce_gehrhardt_moderate_1921"

#' @rdname yield_tables
"fe_ytable_pine_gehrhardt_moderate_1921"

#' @rdname yield_tables
"fe_ytable_spruce_guttenberg_1915"

#' @rdname yield_tables
"fe_ytable_silver_fir_hausser_moderate_1956"

#' @rdname yield_tables
"fe_ytable_oak_juettner_moderate_1955"

#' @rdname yield_tables
"fe_ytable_blackalder_mitscherlich_heavy_1945"

#' @rdname yield_tables
"fe_ytable_larch_schober_moderate_1946"

#' @rdname yield_tables
"fe_ytable_japanlarch_schober_moderate_1953"

#' @rdname yield_tables
"fe_ytable_douglas_schober_moderate_1956"

#' @rdname yield_tables
"fe_ytable_birch_schwappach_1903_29"

#' @rdname yield_tables
"fe_ytable_beech_wiedemann_moderate_1931"

#' @rdname yield_tables
"fe_ytable_spruce_wiedemann_moderate_1936_42"

#' @rdname yield_tables
"fe_ytable_pine_wiedemann_moderate_1943"

#' @rdname yield_tables
"ytable_pine_wiedemann_moderate_1943_raw" # raw data file, see documentation
                                          # of function fe_yield_table()

#' @rdname yield_tables
"fe_ytable_ash_wimmenauer_1919_29"

#' @rdname yield_tables
"fe_ytable_spruce_vanselow_1951"


