% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_area_ha.R
\name{get_area_ha}
\alias{get_area_ha}
\title{Get the Area in ha of a Compatible Object}
\usage{
get_area_ha(x)
}
\arguments{
\item{x}{Object provided by \strong{ForestElementsR} for which an area can be
meaningfully given, typically \code{\link{fe_stand}} or
\code{\link{fe_stand_spatial}}}
}
\value{
The object's area in ha. In case the object \code{x} does not contain
sufficient information, the function returns NULL.
}
\description{
The function \code{get_area_ha} will return the correct area for all
appropriate objects provided by \strong{ForestElementsR}. While the
\code{\link{fe_stand}} class contains this information directly, this is not
the case for the \code{\link{fe_stand_spatial}} class. However,
\code{get_area_ha} will work for both (and other objects to be implemented)
in the same way. In case the object \code{x} does not contain sufficient
information, the function returns NULL.
}
\examples{
# Example for an fe_stand object
selection_forest_1_fe_stand |> get_area_ha()

# Example for an fe_stand_spatial object
mm_forest_1_fe_stand_spatial |> get_area_ha()

}
