% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_q_from_d_q.R
\name{h_q_from_d_q}
\alias{h_q_from_d_q}
\title{Estimate Quadratic Mean Height from Quadratic Mean Diameter}
\usage{
h_q_from_d_q(species_id, d_q_cm)
}
\arguments{
\item{species_id}{vector of species codes in any format that can be converted
into the tum_wwk_short species coding (see examples)}

\item{d_q_cm}{vector of quadratic mean stand (cohort) diameters in cm for
which a corresponding mean height estimate is required}
}
\value{
vector of estimated quadratic mean heights corresponding to the given
values of \code{d_q_cm}
}
\description{
Fallback function to be used in the unfortunate case when a mean stand
(cohort) height value is required but nothing useful is contained in the
available data. The function has originally been developed for and used in
the forest growth simulator SILVA
\insertCite{pretzsch_single_2002}{ForestElementsR}. The version here is
slightly simplified for the species Norway spruce and soft deciduous woods
(codes 1 and 9 in the species coding \code{\link{fe_species_tum_wwk_short}}),
because the original version requires non-standard information which is not
available outside the simulator.
}
\details{
A typical application of this function would be to calculate the quadratic
mean diameter, \code{\link{d_q}} of the tree cohort of interest. If height
information is totally lacking, a reasonable fallback value of the
corresponding quadratic mean height, h_q, can be obtained from this function.
Both values could then be used as the entry point of a standard height curve
system (like \code{\link{h_standard_gnfi3}} and \code{\link{h_standard_bv}})
in order to get plausible height estimates for the single trees in the
cohort. Be aware that, though the height estimates obtained from this
function are plausible, they should be interpreted with care, because the
variation of mean stand height at a given mean diameter is very high in
reality.
}
\examples{
 # Species codes handed to h_q_from_d_q will be attempted to convert
 # into tum_wwk_short
 h_q_from_d_q(5, 25.4) # Apply to a common beech stand width d_q = 25.4 cm
 h_q_from_d_q(fe_species_ger_nfi_2012(100), 25.4)

 # Works also vectorized, i.e. when vectors of d_q values and species codes
 # are given
 species <- fe_species_tum_wwk_short(c(1, 3, 5))
 d_qmean <- c(23.2, 47.2, 12.7)
 h_q_from_d_q(species, d_qmean)

# Typical application: From diameter values to single tree height estimates
# when no height information is available
# - single tree diameters in a stand/cohort
dbh <- c(10.2, 43.3, 37.5, 28.8, 12.4, 19.2, 25.4, 27.3, 32.0)
# - quadratic mean diameter
d_qmean <- d_q(dbh)
species <- fe_species_tum_wwk_short(3) # we assume it's a Scots pine stand
# - quadrativ mean height fallback value
h_qest <- h_q_from_d_q(species, d_qmean)
# - single tree height estimates with the German National Inventory height
#   curve system
h_standard_gnfi3(species, dbh, d_qmean, h_qest)

}
\references{
\insertAllCited{}
}
\seealso{
Other stand heights: 
\code{\link{h_100}()},
\code{\link{h_dom_weise}()},
\code{\link{h_q}()}
}
\concept{stand heights}
