% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fossils.R
\name{fossils}
\alias{fossils}
\alias{as.fossils}
\alias{is.fossils}
\title{Fossils object}
\usage{
fossils(data = NULL, from.taxonomy = FALSE)

as.fossils(data, from.taxonomy = FALSE)

is.fossils(data)
}
\arguments{
\item{data}{Dataframe or list of sampled fossils. See Details for the list of required fields. If NULL, the function creates an empty fossils object.}

\item{from.taxonomy}{Boolean indicating whether the fossils were sampled using a taxonomy object, as opposed to a tree object. Default = FALSE.}
}
\description{
Create a fossil record object. The input is taken to be a dataframe or list.
}
\details{
The fossil record object contains 4 fields for each fossil with the following information:
\itemize{
 \item \code{sp} the label of the corresponding species. This label matches the edge labels in the corresponding phylo object or the species labels in the corresponding taxonomy object if additional taxonomic
 information was provided
 \item \code{edge} the label of the sampled node or tip in the phylogeny, i.e the node at the end of the edge along which the fossil was sampled
 \item \code{hmin} the age of the fossil or the youngest bound of the time interval in which the fossil was sampled
 \item \code{hmax} the oldest bound of the time interval in which the fossil was sampled.
 This is equal to \code{hmin} if exact sampling times are known
}
}
