% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SFRR.R
\name{SFRR}
\alias{SFRR}
\title{Raking ratio estimator}
\usage{
SFRR(ysA, ysB, pi_A, pi_B, pik_ab_B, pik_ba_A, domains_A, domains_B, N_A, N_B,
conf_level = NULL)
}
\arguments{
\item{ysA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{c} containing information about variable of interest from \eqn{s_A}.}

\item{ysB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{c} containing information about variable of interest from \eqn{s_B}.}

\item{pi_A}{A numeric vector of length \eqn{n_A} or a square numeric matrix of dimension \eqn{n_A} containing first order or first and second order inclusion probabilities for units included in \eqn{s_A}.}

\item{pi_B}{A numeric vector of length \eqn{n_B} or a square numeric matrix of dimension \eqn{n_B} containing first order or first and second order inclusion probabilities for units included in \eqn{s_B}.}

\item{pik_ab_B}{A numeric vector of size \eqn{n_A} containing first order inclusion probabilities according to sampling desing in frame B for units belonging
to overlap domain that have been selected in \eqn{s_A}.}

\item{pik_ba_A}{A numeric vector of size \eqn{n_B} containing first order inclusion probabilities according to sampling desing in frame A for units belonging
to overlap domain that have been selected in \eqn{s_A}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "b" and "ba".}

\item{N_A}{A numeric value indicating the size of frame A}

\item{N_B}{A numeric value indicating the size of frame B}

\item{conf_level}{(Optional) A numeric value indicating the confidence level for the confidence intervals, if desired.}
}
\value{
\code{SFRR} returns an object of class "EstimatorDF" which is a list with, at least, the following components:
 \item{Call}{the matched call.}
 \item{Est}{total and mean estimation for main variable(s).}
 \item{VarEst}{variance estimation for main variable(s).}
 If parameter \code{conf_level} is different from \code{NULL}, object includes component
 \item{ConfInt}{total and mean estimation and confidence intervals for main variables(s).}
 In addition, components \code{TotDomEst} and \code{MeanDomEst} are available when estimator is based on estimators of the domains. Component \code{Param} shows value of parameters involded in calculation of the estimator (if any).
 By default, only \code{Est} component (or \code{ConfInt} component, if parameter \code{conf_level} is different from \code{NULL}) is shown. It is possible to access to all the components of the objects by using function \code{summary}.
}
\description{
Produces estimates for population total and mean using the raking ratio estimator from survey data obtained
 from a dual frame sampling desing. Confidence intervals are also computed, if required.
}
\details{
Raking ratio estimator of population total is given by
 \deqn{\hat{Y}_{SFRR} = \frac{N_A - \hat{N}_{ab,rake}}{\hat{N}_a^A}\hat{Y}_a^A + \frac{N_B - \hat{N}_{ab,rake}}{\hat{N}_b^B}\hat{Y}_b^B + \frac{\hat{N}_{ab,rake}}{\hat{N}_{abS}}\hat{Y}_{abS}}
 where \eqn{\hat{Y}_{abS} = \sum_{i \in s_{ab}^A}\tilde{d}_i^Ay_i + \sum_{i \in s_{ab}^B}\tilde{d}_i^By_i, \hat{N}_{abS} = \sum_{i \in s_{ab}^A}\tilde{d}_i^A + \sum_{i \in s_{ab}^B}\tilde{d}_i^B} and
 \eqn{\hat{N}_{ab,rake}} is the smallest root of the quadratic equation \eqn{\hat{N}_{ab,rake}x^2 - [\hat{N}_{ab,rake}(N_A + N_B) + \hat{N}_{aS}\hat{N}_{bS}]x + \hat{N}_{ab,rake}N_AN_B = 0},
 with \eqn{\hat{N}_{aS} = \sum_{s_a^A}\tilde{d}_i^B} and \eqn{\hat{N}_{bS} = \sum_{s_b^B}\tilde{d}_i^B}. Weights \eqn{\tilde{d}_i^A} and \eqn{\tilde{d}_i^B} are obtained as follows
 \eqn{\tilde{d}_i^A =\left\{\begin{array}{lcc}
 d_i^A & \textrm{if } i \in a\\
 (1/d_i^A + 1/d_i^B)^{-1} & \textrm{if } i \in ab
 \end{array}
 \right.}
 and
 \eqn{\tilde{d}_i^B =\left\{\begin{array}{lcc}
 d_i^B & \textrm{if } i \in b\\
 (1/d_i^A + 1/d_i^B)^{-1} & \textrm{if } i \in ba
 \end{array}
 \right.}
 being \eqn{d_i^A} and \eqn{d_i^B} the design weights, obtained as the inverse of the first order inclusion probabilities, that is \eqn{d_i^A = 1/\pi_i^A} and \eqn{d_i^B = 1/\pi_i^B}.

 To obtain an estimator of the variance for this estimator, one has taken into account that raking ratio estimator coincides with SF calibration estimator when frame sizes are known and "raking"
 method is used. So, one can use here Deville's expression to calculate an estimator for the variance of the raking ratio estimator
 \deqn{\hat{V}(\hat{Y}_{SFRR}) = \frac{1}{1-\sum_{k\in s} a_k^2}\sum_{k\in s}(1-\pi_k)\left(\frac{e_k}{\pi_k} - \sum_{l\in s} a_{l} \frac{e_l}{\pi_l}\right)^2}
 where \eqn{a_k=(1-\pi_k)/\sum_{l\in s} (1-\pi_l)} and \eqn{e_k} are the residuals of the regression with auxiliary variables as regressors.
}
\examples{
data(DatA)
data(DatB)
data(PiklA)
data(PiklB)

#Let calculate raking ratio estimator for population total for variable Clothing
SFRR(DatA$Clo, DatB$Clo, PiklA, PiklB, DatA$ProbB, DatB$ProbA, DatA$Domain,
DatB$Domain, 1735, 1191)

#Now, let calculate raking ratio estimator and a 90\% confidence interval for
#population total for variable Feeding, considering only first order inclusion probabilities
SFRR(DatA$Feed, DatB$Feed, DatA$ProbA, DatB$ProbB, DatA$ProbB, DatB$ProbA,
DatA$Domain, DatB$Domain, 1735, 1191, 0.90)
}
\references{
Lohr, S. and Rao, J.N.K. (2000).
\emph{Inference in Dual Frame Surveys}. Journal of the American Statistical Association, Vol. 95, 271 - 280.

Rao, J.N.K. and Skinner, C.J. (1996).
\emph{Estimation in Dual Frame Surveys with Complex Designs}. Proceedings of the Survey Method Section, Statistical Society of Canada, 63 - 68.

Skinner, C.J. and Rao J.N.K. (1996).
\emph{Estimation in Dual Frame Surveys with Complex Designs}. Journal of the American Statistical Association, Vol. 91, 443, 349 - 356.

Skinner, C.J. (1991).
\emph{On the Efficiency of Raking Ratio Estimation for Multiple Frame Surveys}. Journal of the American Statistical Association, Vol. 86, 779 - 784.
}
\seealso{
\code{\link{JackSFRR}}
}

