\name{fpca.cluster}
\alias{fpca.cluster}
\alias{fpca.nonscore.cluster}
\alias{fpca.score.cluster}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Clustering the estimators along the path.
}
\description{
To use k-means to cluster the estimators along the path and get the community labels. \code{fpca.cluster} is a wrap up of functions \code{\link{fpca.nonscore.cluster}} and \code{\link{fpca.score.cluster}}. The latter two are the clustering functions for the situations in which \code{score = FALSE} and \code{score = TRUE}, respectively.
}
\usage{
fpca.cluster(obj, K = 2, score = F)
fpca.nonscore.cluster(obj, K = 2)
fpca.score.cluster(obj, K = 2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{obj}{
in function \code{fpca.cluster}, it is an object generated by \code{\link{fpca.start}}, i.e., generated by 
\code{\link{fpca.nonscore}} or \code{\link{fpca.score}}, if \code{score = FALSE} or \code{score = TRUE}, respectively. It is a list.

In functions \code{fpca.nonscore.cluster} and \code{fpca.score.cluster}, it is an input matrix, which is a \code{FPCA} or \code{FPCA-RoE} object, of dimension number of non-isolated nodes x number of effective estimators. It is generated by \code{\link{fpca.nonscore}} and \code{\link{fpca.score}}.
}
  \item{K}{
input integer -- the pre-specified number of communities, with the default value 2.
}
  \item{score}{
indicator argument -- whether to apply the score associated clustering method or not, with the default value FALSE.
}
}
\value{
an array of community labels list, of dimension number of non-isolated nodes x number of effective estimators. Each entry has value from 1 to K, as an index of the community label. Notice, the community labels are usually permutation-invariant.
}
\references{
Yang Feng, Richard J. Samworth and Yi Yu, Community Detection via Fused Principal Component Analysis, manuscript.
Holland, P.W., Laskey, K.B. and Leinhardt, S., 1983. Stochastic block models: first steps. Social Networks 5, 109-137.
Jin, J., 2012. Fast community detection by score.
Karrer, B. and Newman, M.E.J., 2011. Stochastic blockmodels and community structure in networks. Physical Review E 83, 016107.
}
\author{
Yang Feng, Richard J. Samworth and Yi Yu
}
\section{Warning }{if the input object \code{obj} is a \code{FPCA} object, the supposed value for \code{score} should be \code{F}. If users set \code{score = T}, the function will stop with warning \code{'This object is designed for 'score = F''}. If the input object \code{obj} is a \code{FPCA-RoE} object, the supposed value for \code{score} should be \code{T}. If users set \code{score = F}, the function will still execute, but with warning 'This object is designed for 'score = T''.}
\seealso{
\code{\link{fpca.nonscore.cluster}}, \code{\link{fpca.score.cluster}}, \code{\link{fpca.start}}, \code{\link{fpca.nonscore}}, \code{\link{fpca.score}}.
}
\examples{
### please see the examples in fpca
}

