% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_fuzzyScaleItem.R
\name{fuzzyScaleItem}
\alias{fuzzyScaleItem}
\title{Fuzzy supplementary poverty estimation}
\usage{
fuzzyScaleItem(item, weight, ID, ...)
}
\arguments{
\item{item}{A factor or numeric vector representing answers to an item (a column of data) that has to be rescaled. it will be converted to an ordered factor.}

\item{weight}{A vector of sampling weights. If it is NULL (the default) weights are assigned assuming simple random sampling of units.}

\item{ID}{A vector of length \code{nrow(data)} containing individuals IDs. if NULL (the default) row numbers will be used.}

\item{...}{other parameters}
}
\value{
The item rescaled according to Betti et. al 2018.
}
\description{
Step 2. It calculates deprivation score for item j and ind. i as $d_{j,i} = (1-F(c_{j,i})) / (1-F(1)) where F(c_{j,i})$ is the value of j-th item cumulation function for the i individual
}
\references{
#' Betti, G., Gagliardi, F., & Verma, V. (2018). Simplified Jackknife variance estimates for fuzzy measures of multidimensional poverty. International Statistical Review, 86(1), 68-86.
}
