% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FANOVA_Approximation_07122018.R
\name{FANOVA.approximation}
\alias{FANOVA.approximation}
\title{Computes a FANOVA model by an approximation}
\usage{
FANOVA.approximation(
  formula,
  dataset,
  data.fuzzified,
  sig,
  breakpoints = 100,
  int.method = "int.simpson",
  plot = TRUE
)
}
\arguments{
\item{formula}{a description of the model to be fitted.}

\item{dataset}{the data frame containing all the variables of the model.}

\item{data.fuzzified}{the fuzzified data set constructed by a call to the function FUZZ or the function GFUZZ, or a similar matrix.}

\item{sig}{a numerical value representing the significance level of the test.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{int.method}{the method of numerical integration. It is set by default to the Simpson method, i.e. int.method="int.simpson".}

\item{plot}{fixed by default to "TRUE". plot="FALSE" if a plot of the fuzzy number is not required.}
}
\value{
Returns a list of all the arguments of the function, the total, treatment and residuals sums of squares, the coefficients of the model, the test statistics with the corresponding p-values, and the decision made.
}
\description{
Computes a FANOVA model by an approximation
}
