% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTukeyHSD_20200302.R
\name{FTukeyHSD}
\alias{FTukeyHSD}
\title{Calculates the Tukey HSD test corresponding to the fuzzy response variable}
\usage{
FTukeyHSD(test, variable, cont = c(1, -1), conf.level = 0.95)
}
\arguments{
\item{test}{a result of a call of the function FMANOVA.}

\item{variable}{the name of a variable in the data set.}

\item{cont}{the contrasts of the model. It is set by default to c(1,-1).}

\item{conf.level}{the confidence level of the test. It is set by default to 0.95.}
}
\value{
Returns a table of comparisons of means of the different levels of a given factor, two by two. 
The table contains the means of populations, the lower and upper bounds of the confidence intervals, and their p-values.
}
\description{
Calculates the Tukey HSD test corresponding to the fuzzy response variable
}
\examples{
mat <- matrix(c(2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,3,4,4,3,1,2,5,4,4,3),ncol=3)
data <- data.frame(mat)
MF131 <- TrapezoidalFuzzyNumber(0,1,1,2)
MF132 <- TrapezoidalFuzzyNumber(1,2,2,3)
MF133 <- TrapezoidalFuzzyNumber(2,3,3,4)
MF134 <- TrapezoidalFuzzyNumber(3,4,4,5)
MF135 <- TrapezoidalFuzzyNumber(4,5,5,6)
PA13 <- c(1,2,3,4,5); mi <- 1; si <- 3
Yfuzz <- FUZZ(data,1,3,PA13)
attach(data)
formula <- X3 ~ X1 + X2
res <- FMANOVA(formula, data, Yfuzz, method = "distance", distance.type = "wabl")
FTukeyHSD(res, "X1")[[1]]
detach(data)
}
