% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{Utils}
\alias{Utils}
\title{'Utils' to convert real data into the corresponding 'StatList'.}
\description{
'Utils' contain an auxiliary method that perform the conversion of an archive with
rda extension (R Data File), that contains real data, to the corresponding
'TrapezoidalFuzzyNumberList'.
}
\note{
In case you find (almost surely existing) bugs or have recommendations
for improving the method comments are welcome to the below mentioned mail addresses.
}
\examples{

## ------------------------------------------------
## Method `Utils$convertTra`
## ------------------------------------------------

# Example 1:
Utils$new()$convertTra(M1)

# Example 2:
Utils$new()$convertTra(M2)

# Example 3:
Utils$new()$convertTra(M3)

# Example 4:
Utils$new()$convertTra(S1)

# Example 5:
m=as.data.frame(matrix(c(NA, 1, 2, NA, 3, 2,2,NA,1,3,NA,NA,6,4,NA,NA),ncol=4))
Utils$new()$convertTra(m)
}
\author{
Andrea Garcia Cernuda <uo270115@uniovi.es>
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Utils-convertTra}{\code{Utils$convertTra()}}
\item \href{#method-Utils-clone}{\code{Utils$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Utils-convertTra"></a>}}
\if{latex}{\out{\hypertarget{method-Utils-convertTra}{}}}
\subsection{Method \code{convertTra()}}{
This method generates n 'TrapezoidalFuzzyNumbers' contained in a 'TrapezoidalFuzzyNumberList'
obtained from the rows and columns of R Data File. If the data contains any NA value, the
row will be deleted as a 'TrapezpidalFuzzyNumber' have to be created with double values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Utils$convertTra(d = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{d}}{is the R Data File already loaded in the environment with data("example").
If the user wants to use M1, M2, M3 or S1, they are already loaded in the
package environment through the archive data.R.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a TrapezoidalFuzzyNumberList with n TrapezoidalFuzzyNumbers. Each
one is characterized by its four values inf0, inf1, sup1, sup0. The TrapezoidalFuzzyNumbers
are obtained from the rows and columns of R Data File. If the body's method inner conditions
are not met, NA will be returned.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
Utils$new()$convertTra(M1)

# Example 2:
Utils$new()$convertTra(M2)

# Example 3:
Utils$new()$convertTra(M3)

# Example 4:
Utils$new()$convertTra(S1)

# Example 5:
m=as.data.frame(matrix(c(NA, 1, 2, NA, 3, 2,2,NA,1,3,NA,NA,6,4,NA,NA),ncol=4))
Utils$new()$convertTra(m)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Utils-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Utils-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Utils$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
