% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDA_outputs_synthesis.R
\name{RDA_outputs_synthesis}
\alias{RDA_outputs_synthesis}
\title{RDA_outputs_synthesis function}
\usage{
RDA_outputs_synthesis(RDA, MVAsynth, MVAanova, RDATable)
}
\arguments{
\item{RDA}{The RDA object : RDA <- vegan::rda(mtcars_quant~gear+carb,data=mtcars)}

\item{MVAsynth}{TRUE or FALSE. TRUE : displaying RVAideMemoire::MVA.synth(RDA) outputs.}

\item{MVAanova}{TRUE or FALSE. TRUE : displaying RVAideMemoire::MVA.anova(RDA) outputs.}

\item{RDATable}{TRUE or FALSE. TRUE : calculate and display the variance percentage of considered factor / total unconstrained variance.}
}
\value{
Results can be displayed in the console. Outputs are saved in a data frame
}
\description{
This function facilitate the use and outputs synthesis of RDA analysis performed by the vegan and RVAideMemoire packages.
This function is mainly derived from the explanations of Maxime Herve
\url{https://www.maximeherve.com/r-et-statistiques}
}
\examples{

library(vegan)
my.RDA <- vegan::rda(mtcars[,1:7]~vs+am+gear, data=mtcars)
RDA_outputs_synthesis(RDA = my.RDA, MVAsynth = TRUE, MVAanova = FALSE, RDATable = TRUE)




}
