% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space_fill.R
\name{space_fill}
\alias{space_fill}
\title{Create Space-Filling Design}
\usage{
space_fill(lower_bound, upper_bound, budget)
}
\arguments{
\item{lower_bound}{A vector of length \code{d}.}

\item{upper_bound}{A vector of length \code{d}.}

\item{budget}{An integer.}
}
\value{
A matrix with \code{budget} rows and \code{d} columns.
}
\description{
Generates a maximin latin hypercube sample (LHS) covering the space defined by \code{lower_bound} and \code{upper_bound} with \code{budget} number of points. The resulting LHS is shifted and scaled to the domain defined by  \code{lower_bound} and \code{upper_bound}.
}
\examples{
my_lhs <- space_fill(c(0,0),c(10,10),20)
plot(my_lhs)
}
