% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBOP2_maxP_singleE.gbop2.R
\name{GBOP2_maxP_singleE}
\alias{GBOP2_maxP_singleE}
\title{PSOGO: Power maximizing design with single boundary for futility}
\usage{
GBOP2_maxP_singleE(
  nlooks = 1,
  p0 = 0.2,
  p1 = 0.4,
  err1 = 0.05,
  minPower = 0.8,
  totalPatients = 5,
  Nmin_cohort1 = 1,
  Nmin_increase = 1,
  pso_method = "default",
  nParallel = NULL,
  seed = 1024,
  nSwarm = 1,
  maxIter = 1
)
}
\arguments{
\item{nlooks}{number of interim looks}

\item{p0}{Null hypothesis response rate}

\item{p1}{Alternative hypothesis response rate}

\item{err1}{Type I error rate}

\item{minPower}{power}

\item{totalPatients}{total number of patients}

\item{Nmin_cohort1}{minimum number of first cohort}

\item{Nmin_increase}{minimum number of increase in each cohort}

\item{pso_method}{"all" for using three distinct pso, otherwise indicate single pso method}

\item{nParallel}{number of pso ensemble}

\item{seed}{Random seed for reproducibility}

\item{nSwarm}{nSwarm for pso}

\item{maxIter}{maxIter for pso}
}
\value{
A list on design parameters and operating characteristics
}
\description{
This function implements PSOGO to find a power maximizing design with single boundary for futility.
}
\details{
Parallel computing is only used when the user explicitly sets nCore > 1. No more than 2 cores should be used
unless the user is aware and permits it. The function defaults to sequential execution. If multiple analyses
are planned, consider using \code{init_cluster(nCore)} and \code{stop_cluster()} manually to control the backend.
}
\examples{
\donttest{
# init_cluster(2)
#   GBOP2_maxP_singleE(
#   nlooks = 1, 
#   p0 = 0.2, 
#   p1 = 0.4, 
#   err1 = 0.05, 
#   minPower = 0.8, 
#   totalPatients = 26, 
#   Nmin_cohort1 = 10, 
#   Nmin_increase = 5, 
#   pso_method = "default", 
#   nParallel = 1, 
#   seed = 1024, 
#   nSwarm = 64, 
#   maxIter = 200
# )
# stop_cluster()  # Only if init_cluster() was used
#  
message("Run GBOP2_minSS_singleE() manually for real optimization.")
}


}
