% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryDS.R
\name{summaryDS}
\alias{summaryDS}
\title{Summary function of Dirac Spike}
\usage{
summaryDS(object)
}
\arguments{
\item{object}{a result of a call to DS}
}
\value{
\itemize{
\item Name of Gene: the component from object.
\item Number of SNPs: the component from object.
\item Name of SNPs: the component from object.
\item log10BF: the component from object.
\item lBFDR: the component from object.
\item theta: the component from object.
\item Significance based on CI: the component from object.
\item Significance based on median thresholding: the component from object.
}
}
\description{
summaryDS is a generic function used to produce result summaries of the results of DS function.
}
\examples{
############################# Gene DNAJC1 ###############################################
data(DNAJC1)
Breast <- DNAJC1$Breast
Thyroid <- DNAJC1$Thyroid
genename <- "DNAJC1"
snpnames <- Breast$snp
Betah <- list(Breast$beta, Thyroid$beta)
Sigmah <- list(diag(Breast$se^2), diag(Thyroid$se^2))
K <- 2
m <- 14


RES <- DS(Betah, Sigmah,
  kappa0 = 0.5, sigma20 = 1,
  m = m, K = K, niter = 2000, burnin = 1000, nthin = 2, nchains = 1,
  a1 = 0.1, a2 = 0.1, d1 = 0.1, d2 = 0.1, snpnames, genename
)
summaryDS(RES)
}
\references{
Baghfalaki, T., Sugier, P. E., Truong, T., Pettitt, A. N., Mengersen, K., & Liquet, B. (2021). Bayesian meta analysis models for cross cancer genomic investigation of pleiotropic effects using group structure. Statistics in Medicine, 40(6), 1498-1518.
}
\author{
Taban Baghfalaki.
}
