% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_peaks.R
\name{norm_peaks}
\alias{norm_peaks}
\title{Normalisation of peak abundancies}
\usage{
norm_peaks(
  data,
  conc_col_name = NULL,
  rt_col_name = NULL,
  out = c("data.frame", "list")
)
}
\arguments{
\item{data}{Object of class GCalign created with \code{\link{align_chromatograms}} or a list of data frames that contain peak list of individual samples.}

\item{conc_col_name}{Character giving the name of a column in \code{data} containing a variable describing the abundance of peaks (e.g. peak area or peak height).}

\item{rt_col_name}{A character giving the name of the column containing the retention times. The decimal separator needs to be a point.}

\item{out}{character defining the format of the returned data. Either "List" or "data.frame".}
}
\value{
Depending on \code{out} either a list of data frame or a single data frame were rows represent samples and columns relative peak abundances. Abundances are given as percentages.

 @author Martin Stoffel (martin.adam.stoffel@gmail.com) &
        Meinolf Ottensmann (meinolf.ottensmann@web.de)
}
\description{
Calculates the relative abundance of a peak by normalising an intensity measure with regard to the cumulative abundance of all peaks that are present within an individual sample. The desired measure of peak abundance needs to be included in a column of the input dataset aligned with \code{\link{align_chromatograms}}.
}
\examples{
## aligned gc-dataset
data("aligned_peak_data")
## returns normalised peak area
norm_peaks(data = aligned_peak_data, conc_col_name = "area", rt_col_name = "time")

}
