% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optidisc.R
\name{optidisc}
\alias{optidisc}
\alias{print.optidisc}
\alias{plot.optidisc}
\title{Optimal discretization for continuous variables and visualization.}
\usage{
optidisc(continuous_variable, response_variable,
        discmethod = discmethod, discitv = discitv)
\method{print}{optidisc}(x, ...)
\method{plot}{optidisc}(x, ...)
}
\arguments{
\item{continuous_variable}{A vector or a data.frame of continuous explanatory variables}

\item{response_variable}{A vector of response variable}

\item{discmethod}{A character vector of discretization methods}

\item{discitv}{A numeric vector of numbers of intervals}

\item{x}{A list of \code{optidisc} result}

\item{...}{Ignore}
}
\description{
Optimal discretization for continuous variables and visualization.
}
\examples{
## set optional discretization methods and numbers of intervals
# optional methods: equal, natural, quantile, geometric, sd and manual
discmethod <- c("equal","natural","quantile","geometric","sd")
discitv <- c(3:7)
## optimal discretization
odc1 <- optidisc(ndvi_40$Tempchange, ndvi_40$NDVIchange, discmethod, discitv)
odc1
plot(odc1)

}
