% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertGDP.R
\name{convertGDP}
\alias{convertGDP}
\title{Convert GDP data}
\usage{
convertGDP(
  gdp,
  unit_in,
  unit_out,
  source = "wb_wdi",
  with_regions = NULL,
  replace_NAs = NULL,
  verbose = getOption("GDPuc.verbose", default = FALSE),
  return_cfs = FALSE
)
}
\arguments{
\item{gdp}{A tibble, data frame or magpie object, the latter of which
requires the \href{https://github.com/pik-piam/magclass}{magclass}
package to be installed. The data-frame needs to have at least 3 columns:
\itemize{
\item a character column with iso3c
(\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{wikipedia}) country codes,
\item a numeric column with years,
\item a numeric column named "value" with GDP values.
}}

\item{unit_in}{A string with the incoming GDP unit, one of:
\itemize{
\item "current LCU"
\item "current Int$PPP"
\item "current US$MER"
\item "constant YYYY LCU"
\item "constant YYYY Int$PPP"
\item "constant YYYY US$MER"
}
where YYYY should be replaced with a year e.g. "2010" or "2017".}

\item{unit_out}{A string with the outgoing GDP unit, one of:
\itemize{
\item "current LCU"
\item "current Int$PPP"
\item "current US$MER"
\item "constant YYYY LCU"
\item "constant YYYY Int$PPP"
\item "constant YYYY US$MER"
}
where YYYY should be replaced with a year e.g. "2010" or "2017".}

\item{source}{A string referring to a package internal data frame containing the conversion factors, or
a data-frame that exists in the calling environment.
Use \href{https://johanneskoch94.github.io/GDPuc/reference/print_source_info.html}{print_source_info()}
to learn about the available sources.}

\item{with_regions}{NULL or a data-frame. The data-frame should be "country to region
mapping": one column named "iso3c" with iso3c country codes, and one column named
"region" with region codes to which the countries belong. Any regions in the gdp
object will then be disaggregated according to the region mapping and weighed by the
GDP share of countries in that region in the year of the unit, converted on a country
level, and re-aggregated before being returned.}

\item{replace_NAs}{NULL by default, meaning no NA replacement. Can be set to one of the following:
\itemize{
\item 0: resulting NAs are simply replaced with 0.
\item "no_conversion": resulting NAs are simply replaced with the values from the gdp argument.
\item "linear": missing conversion factors in the source object are inter- and extrapolated linearly.
For the extrapolation, the closest 5 data points are used.
\item "regional_average": missing conversion factors in the source object are replaced with
the regional average of the region to which the country belongs. This requires a region-mapping to
be passed to the function, see the with_regions argument.
}
Can also be a vector with "linear" as first element, e.g. c("linear", 0) or c("linear", "no_conversion"),
in which case, the operations are done in sequence.}

\item{verbose}{TRUE or FALSE. A flag to turn verbosity on or off. Be default it is equal to the
GDPuc.verbose option, which is FALSE if not set to TRUE by the user.}

\item{return_cfs}{TRUE or FALSE. Set to TRUE to additionally return a tibble with the conversion factors
used. In that case a list is returned with the converted GDP under "result", and the conversion factors
used under "cfs".}
}
\value{
The gdp argument, with the values in the "value" column, converted to unit_out. If the argument
return_cfs is TRUE, then a list is returned with the converted GDP under "result", and the conversion
factors used under "cfs".
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

convertGDP() converts GDP time series data from one unit to another, using GDP
deflators, market exchange rates (MERs) and purchasing power parity
conversion factors (PPPs).
}
\details{
When providing a custom source to the function, a certain format is required.
The source object must be a data frame or tibble with at least the following columns:
\itemize{
\item a character column named "iso3c" with iso3c
(\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{wikipedia}) country codes,
\item a numeric column named "year" with years,
\item a numeric column named "GDP deflator" with values of the GDP deflator divided
by 100 (so that in the base year the GDP deflator is equal to 1, not 100).
The base year of the deflator can be any year, and can be country-specific.
\item a numeric column named "MER (LCU per US$)" with MER values,
\item a numeric column named "PPP conversion factor, GDP (LCU per international $)"
wit PPP exchange rate values.
}
}
\seealso{
The \href{https://github.com/vincentarelbundock/countrycode}{countrycode}
package to convert country codes.
}
