% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemTwoCountry_RealExchangeRateIndex_7_4.R
\name{gemTwoCountry_RealExchangeRateIndex_7_4}
\alias{gemTwoCountry_RealExchangeRateIndex_7_4}
\title{Calculating Real Exchange Rate Index}
\usage{
gemTwoCountry_RealExchangeRateIndex_7_4(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\value{
A real exchange rate index.
}
\description{
Some examples of calculating the real exchange rate index in a two-country economy.
}
\examples{
\donttest{
# es.DFProd is the substitution elasticity between domestic and foreign products.
makeDstl <- function(es.DFProd = 0.5,
                     alpha.firm.CHN = 1,
                     beta.household.CHN = c(0.75, 0.25),
                     outbound.investment.rate = 0.25) {
  es.CL <- 0.8 # substitution elasticity between capital and labor

  dst.firm.CHN <- node_new("output",
    type = "SCES", alpha = alpha.firm.CHN, beta = c(0.75, 0.25), es = es.CL,
    "lab.CHN", "cap.CHN"
  )

  dst.household.CHN <- node_new("util",
    type = "FIN", rate = c(1, outbound.investment.rate),
    "cc1", "bond.ROW"
  ) # 0.1 is the amount of foreign investment corresponding to
  # each unit of cc1 (i.e. composite commodity 1).

  node_set(dst.household.CHN, "cc1",
    type = "SCES", alpha = 1, beta = beta.household.CHN, es = es.DFProd,
    "prod.CHN", "prod.ROW"
  )

  node_plot(dst.household.CHN)

  dst.firm.ROW <- node_new("output",
    type = "SCES", alpha = 1, beta = c(0.5, 0.5), es = es.CL,
    "lab.ROW", "cap.ROW"
  )

  dst.household.ROW <- node_new("util",
    type = "SCES", alpha = 1, beta = c(0.05, 0.95), es = es.DFProd,
    "prod.CHN", "prod.ROW"
  )

  list(dst.firm.CHN, dst.household.CHN, dst.firm.ROW, dst.household.ROW)
}

dstl <- makeDstl()

SExg <- {
  tmp <- matrix(NA, 7, 4, TRUE)
  tmp[2, 2] <- 30 # the supply of lab.CHN
  tmp[3, 2] <- 10 # the supply of cap.CHN
  tmp[5, 4] <- 156 # the supply of lab.ROW
  tmp[6, 4] <- 156 # the supply of cap.ROW
  tmp[7, 4] <- 8 # the supply of bond.ROW
  tmp
}

f <- function(A = dstl,
              S0Exg = SExg) {
  sdm2(
    A = A,
    names.commodity = c(
      "prod.CHN", "lab.CHN", "cap.CHN",
      "prod.ROW", "lab.ROW", "cap.ROW", "bond.ROW"
    ),
    names.agent = c(
      "firm.CHN", "household.CHN",
      "firm.ROW", "household.ROW"
    ),
    B = {
      tmp <- matrix(0, 7, 4, TRUE)
      tmp[1, 1] <- tmp[4, 3] <- 1
      tmp
    },
    S0Exg = S0Exg,
    numeraire = "lab.CHN"
  )
}

ge.benchmark <- f()

## real exchange rate index
reri <- function(ge.new, ge.benchmark) {
  weight.CHN <- rowSums(ge.benchmark$SV)[c("prod.CHN", "lab.CHN", "cap.CHN")]
  weight.ROW <- rowSums(ge.benchmark$SV)[c("prod.ROW", "lab.ROW", "cap.ROW")]

  weighted.mean(ge.new$p[c("prod.ROW", "lab.ROW", "cap.ROW")], weight.ROW) /
    weighted.mean(ge.new$p[c("prod.CHN", "lab.CHN", "cap.CHN")], weight.CHN)
}


## technology progress in CHN
reri(f(A = makeDstl(es.DFProd = 5, alpha.firm.CHN = 2)), ge.benchmark)
reri(f(A = makeDstl(es.DFProd = 0.5, alpha.firm.CHN = 2)), ge.benchmark)

## labor supply change in CHN
SExg.LSC <- SExg
SExg.LSC[2, 2] <- SExg.LSC[2, 2] * 2

reri(f(A = makeDstl(es.DFProd = 5), S0Exg = SExg.LSC), ge.benchmark)

reri(f(S0Exg = SExg.LSC), ge.benchmark)

## capital accumulation in CHN
SExg.CA <- SExg
SExg.CA[3, 2] <- SExg.CA[3, 2] * 3

reri(f(A = makeDstl(es.DFProd = 5), S0Exg = SExg.CA), ge.benchmark)

reri(f(S0Exg = SExg.CA), ge.benchmark)

## preference change in China
reri(f(A = makeDstl(es.DFProd = 5, beta.household.CHN = c(0.5, 0.5))), ge.benchmark)
reri(f(A = makeDstl(beta.household.CHN = c(0.5, 0.5))), ge.benchmark)

## outbound-investment-rate change in China
reri(f(A = makeDstl(es.DFProd = 5, outbound.investment.rate = 0.1)), ge.benchmark)
reri(f(A = makeDstl(outbound.investment.rate = 0.1)), ge.benchmark)
}
}
\seealso{
\cite{\link{gemTwoCountry_Bond_7_4}}
}
