% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.RobSBoosting.R
\name{coef.RobSBoosting}
\alias{coef.RobSBoosting}
\title{Extract coefficients from a "RobSBoosting" object}
\usage{
\method{coef}{RobSBoosting}(object, ...)
}
\arguments{
\item{object}{Fitted \code{"RobSBoosting"} model object.}

\item{\dots}{Not used. Other arguments to get coefficients.}
}
\value{
\item{intercept}{The intercept estimate.}
\item{unique_variable}{A matrix with two columns that represents the variables that are selected
for the model after removing the duplicates, since the \code{loop_time} iterations of the method
may produce variables that are repeatedly selected into the model. Here, the first and second
columns correspond to the indexes of environmental (E) factors and genetic (G) factors. For
example, (1, 0) represents that this variable is the first E factor, and (1,2) represents that the
variable is the interaction between the first E factor and second G factor.}
\item{unique_coef}{Coefficients corresponding to \code{unique_variable}. Here, the coefficients
are simple regression coefficients for the linear effect (discrete E factor, G factor, and their
interaction), and B spline coefficients for the nonlinear effect (continuous E factor, and
corresponding G-E interaction).}
\item{unique_knots}{A list of knots corresponding to \code{unique_variable}. Here, when the type
of \code{unique_variable} is discrete E factor, G factor, or their interaction, knot will be NULL,
and knots will be B spline otherwise.}
\item{unique_Boundary.knots}{A list of boundary knots corresponding to \code{unique_variable}.}
\item{unique_vtype}{A vector representing the variable type of \code{unique_variable}. Here, "EC"
stands for continuous E effect, "ED" for discrete E effect, "G" for G effect, "EC-G" for the
interaction between "EC" and "G", and "ED-G" for the interaction between "ED" and "G".}
\item{estimation_results}{A list of estimation results for each variable. Here, the first
\code{q} elemnets are for the E effects, the (\code{q+1}) element
is for the first G effect and the (\code{q+2}) to (\code{2q+1}) elements are for the interactions
corresponding to the first G factor, and so on.}
}
\description{
This function extracts coefficients from a RobSBoosting model, using the stored
\code{"RobSBoosting"} object.
}
\references{
Mengyun Wu and Shuangge Ma.
\emph{Robust semiparametric gene-environment interaction analysis using sparse boosting.
Statistics in Medicine, 38(23):4625-4641, 2019.}
}
\seealso{
\code{RobSBoosting}, and \code{predict}, and \code{plot} methods.
}
