% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulated_data.R
\name{simulated_data}
\alias{simulated_data}
\title{Simulated data for generating response}
\usage{
simulated_data(
  G,
  E,
  alpha,
  beta,
  error,
  family = c("continuous", "survival"),
  a1 = NULL,
  a2 = NULL
)
}
\arguments{
\item{G}{Input matrix of \code{p} genetic (G) measurements consisting of \code{n} rows. Each
row is an observation vector.}

\item{E}{Input matrix of \code{q} environmental (E) risk factors. Each row is an observation
vector.}

\item{alpha}{Matrix of the true coefficients for main E effects.}

\item{beta}{Matrix of the true regression coefficients for all main G effects (the first row) and interactions.}

\item{error}{Error terms.}

\item{family}{Type of the response variable. If \code{family="continuous"}, a quantitative
vector is generated. If \code{family="survival"}, a two-column matrix with the first column
being the log(survival time) and the second column being the censoring indicator is
generated.The indicator is a binary variable, with "1" indicating dead, and "0" indicating
right censored.}

\item{a1}{If \code{family}="survival", we generate the censoring time from a uniform
distribution where \code{a1} is the left endpoint.}

\item{a2}{If \code{family}="survival", we generate the censoring time from a uniform
distribution where \code{a2} is the right endpoint.}
}
\value{
Response variable. A quantitative vector for \code{family="continuous"}. For
\code{family="survival"}, it would be a two-column matrix with the first column being the
log(survival time) and the second column being the censoring indicator. The indicator
is a binary variable, with "1" indicating dead, and "0" indicating right censored.
}
\description{
Generate simulated response.
}
