% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGENEAmodel.R
\name{createGENEAmodel}
\alias{createGENEAmodel}
\title{Create training data decision tree model}
\usage{
createGENEAmodel(data, outputtree = NULL, features = c("Segment.Duration",
  "Principal.Frequency.mad", "UpDown.sd", "Degrees.sd"),
  category = "Activity", plot = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{data}{data frame containing segmented GENEActiv bin data.}

\item{outputtree}{name of the png file that shows the classification tree plot.}

\item{features}{character vector naming independent variables to use in classification.
Alternatively, a numeric vector specifying the variables to pass to the classification 
or NULL, in which case all variables are used in the order of the supplied training dataset.
Note that including large numbers of variables (>7) may result in long run times.}

\item{category}{single character naming the dependent variable to use (default 'Activity').}

\item{plot}{a logical value indicating whether a plot of the classification tree
should be plotted. The default is TRUE.}

\item{verbose}{single logical should additional progress reporting be printed 
at the console? (default \code{TRUE})}

\item{\dots}{other arguments for \code{rpart}}
}
\value{
A GENEA rpart fit.
}
\description{
From data frame create a decision tree that can be used for 
classifying data into specified categories. The data frame may optionally 
contain a reserved column Source, specifying the provenance of the record.
The data frame must contain a column, by default named Activity, specifing 
the classes into which the model fit should be classified.
}
\details{
The function will create an rpart classification tree for the training data based 
upon the parameters passed to features. The model created, an GENEA rpart object can be used 
within the function \code{"\link[=classifyGENEA]{classifyGENEA}"} to classify GENEA bin files.
}
\examples{
## dataPath <- file.path(system.file(package = "GENEAclassify"), 
##    "testdata", "trainingData2.csv")
## t1 <- read.csv(file = dataPath)
## f1 <- createGENEAmodel (data = t1, 
##     features = c("Magnitude.mean", "Degrees.var", "UpDown.mad"))
## class(f1)
## levels(f1)
## features(f1)
## plot(f1)
## text(f1)
}
\seealso{
The returned object can be interrogated with 
    \code{features}, the variables used in defining the model,
    and \code{"\link[=levels.GENEA]{levels}"}, the response categories predicted by the model.
}
