#' Logged international lending volumes for 17 large countries from 2005.
#'
#' A dataset of logged aggregate public and private lending volumes between 17
#' large industrialized countries.
#'
#' @format A matrix with 17 rows and columns and a zero diagonal.
#' @source \url{http://arxiv.org/abs/1505.04015}
"lending_2005"


#' GDP and G8 membership data for 17 large countries from 2005.
#'
#' Metadata for each country in "lending_2005", including GDP, logged GDP, and
#' a G8 membership indicator.
#'
#' @format A data frame with 17 rows and 3 columns
#' @source \url{http://arxiv.org/abs/1505.04015}
"covariate_data_2005"

#' Normalized net exports between 17 large countries from 2005.
#'
#' Aggregate net export volume between countries has been normalized to lie
#' between 0 and 1.
#'
#' @format A matrix with 17 rows and columns and a zero diagonal.
#' @source \url{http://arxiv.org/abs/1505.04015}
"net_exports_2005"
