% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{central_region2d}
\alias{central_region2d}
\title{2D central region / global envelope}
\usage{
central_region2d(image_sets, ...)
}
\arguments{
\item{image_sets}{An image set, i.e. a set of 2d functions (or a list of them).
See \code{\link{create_image_set}}.}

\item{...}{Additional parameters to be passed to \code{\link{central_region}}.}
}
\value{
An object of class "global_envelope2d" (and "list"),
which can be printed and plotted directly.

Essentially a data frame containing columns
\itemize{
\item r = a list of vectors of values of x- and y-coordinates at which the test was made
\item obs = the data function (matrix), if there is only one data function. Otherwise not existing.
\item lo = the lower envelope (matrix) based on the simulated functions
\item hi = the upper envelope (matrix) based on the simulated functions
\item central = the central curve, mean or median (default) of the test functions
T_i(r), i=2, ..., s+1. Used for visualization only.
}
Additionally, the return value has attributes \code{method}, \code{type}, \code{alternative},
\code{k_alpha}, \code{alpha}, \code{k}, and \code{call}, see more detailed description in
\code{\link{central_region}}.
}
\description{
Provides central regions or global envelopes or confidence bands in 2D
}
\references{
Mrkvička, T., Soubeyrand, S., Myllymäki, M., Grabarnik, P. and Hahn, U. (2016). Monte Carlo testing in spatial statistics, with applications to spatial residuals. Spatial Statistics 18, Part A: 40--53. doi: 10.1016/j.spasta.2016.04.005

Myllymäki, M., Mrkvička, T., Grabarnik, P., Seijo, H. and Hahn, U. (2017). Global envelope tests for spatial point patterns. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 79: 381–404. doi: 10.1111/rssb.12172

Mrkvička, T., Hahn, U. and Myllymäki, M. (2018). A one-way ANOVA test for functional data with graphical interpretation. arXiv:1612.03608 [stat.ME]
}
