% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve-set.r
\name{create_curve_set}
\alias{create_curve_set}
\title{Create a curve set}
\usage{
create_curve_set(curve_set, ...)
}
\arguments{
\item{curve_set}{A list containing the element obs, and optionally
the elements r, sim_m and theo. See details.}

\item{...}{For expert use only.}
}
\value{
An object of class \code{curve_set}.
}
\description{
Create a curve set out of a list in the right form.
}
\details{
\code{obs} must be either
\itemize{
\item a vector containing the data function, or
\item a matrix containing the s data functions, in which case it is assumed that
each column corresponds to a data function.
}

If given, \code{r} describes the 1- or 2-dimensional argument values where the curves have been observed (or
simulated). It must be either
\itemize{
\item a vector,
\item a data.frame with columns "x", "y", "width" and "height",
where the width and height give the width and height of the pixels placed at x and y, or
\item a data.frame with columns "xmin", "xmax", "ymin" and "ymax" giving the corner coordinates of the pixels
where the data have been observed.
}

If \code{obs} is a vector, \code{sim_m} must be a matrix containing the simulated functions.
Each column is assumed to correspond to a function, and the number of rows must match the
length of \code{obs}. If \code{obs} is a matrix, \code{sim_m} is ignored.

If \code{obs} is a vector, \code{theo} can be given and it should then correspond
to a theoretical function (e.g., under the null hypothesis). If present, its length must match the length of
\code{obs}.
}
\examples{
# 1d
cset <- create_curve_set(list(r=1:10, obs=matrix(runif(10*5), ncol=5)))
plot(cset)
# 2d
cset <- create_curve_set(list(r=data.frame(x=c(rep(1:3, 3), 4), y=c(rep(1:3, each=3), 1),
                                           width=1, height=1),
                              obs=matrix(runif(10*5), ncol=5)))
plot(cset)
}
