% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GE_test_moment_calcs.R
\name{GE_test_moment_calcs}
\alias{GE_test_moment_calcs}
\title{GE_test_moment_calcs.R}
\usage{
GE_test_moment_calcs(beta_list, rho_list, prob_G, cov_Z = NULL,
  cov_W = NULL, num_sub = 2e+06, test_threshold = 0.003,
  corr_G = NULL)
}
\arguments{
\item{beta_list}{A list of the effect sizes in the true model.
Use the order beta_0, beta_G, beta_E, beta_I, beta_Z, beta_M.
If G or Z or M is a vector, then beta_G/beta_Z/beta_M should be vectors.
If Z and/or M/W do not exist in your model, then set beta_Z and/or beta_M = 0.}

\item{rho_list}{A list of expectations (which happen to be covariances if all covariates
are centered at 0) in the order specified by GE_enumerate_inputs().
If Z and/or M/W do not exist in your model, then treat them as constants 0. For example,
if Z doesn't exist and W includes 2 covariates, then set cov(EZ) = 0 and cov(ZW) = (0,0).
If describing expectations relating two vectors, i.e. Z includes two covariates and W
includes three covariates, sort by the first term and then the second. Thus in the 
example, the first three terms of cov(ZW) are cov(Z_1,W_1),cov(Z_1,W_2), cov(Z_1,W_3), 
and the last three terms are cov(Z_3,W_1), cov(Z_3,W_2), cov(Z_3,W_3).}

\item{prob_G}{Probability that each allele is equal to 1.  Since each SNP has
two alleles, the expectation of G is 2*prob_G. Should be a d*1 vector.}

\item{cov_Z}{Should be a matrix equal to cov(Z) or NULL. Must be specified if Z is a vector.}

\item{cov_W}{Should be a matrix equal to cov(W) or NULL. Must be specified if W is a vector.}

\item{num_sub}{Number of subjects to simulate/test with.}

\item{test_threshold}{How close does our simulated value have to be to the analytic value?}

\item{corr_G}{Should be a matrix giving the *pairwise correlations* between each SNP
in the set, or NULL. Must be specified if G is a vector.  For example, the [2,3] element
of the matrix would be the pairwise correlation between SNP2 and SNP3.}
}
\value{
Nothing
}
\description{
Test function mostly for internal use to ensure the higher order moments (covariances)
calculated in GE_bias_normal_squaredmis() are correct. Will give warning messages if
some calculations appear to be incorrect.  If receive warning messages, run again, and
if still receive the same warning messages, something may be wrong.
}
\examples{
GE_test_moment_calcs(beta_list=as.list(runif(n=6, min=0, max=1)), 
rho_list=as.list(rep(0.3,6)), prob_G=0.3, cov_Z=1, cov_W=1)
}
\keyword{internal}
