% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eip.R
\name{boot_eip}
\alias{boot_eip}
\title{Bootstrapped Edge Inclusion 'Probabilities'}
\usage{
boot_eip(
  Y,
  method = "pearson",
  samples = 50,
  penalty = "atan",
  ic = "bic",
  gamma = NULL,
  lambda = NULL,
  n_lambda = 50,
  n_gamma = 50,
  unreg = FALSE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{Y}{Matrix. A matrix of dimensions \emph{n} by \emph{p}.}

\item{method}{Character string. Which correlation coefficient (or covariance) is to be
computed. One of "pearson" (default), "kendall", or "spearman."
Defaults to \code{pearson}.}

\item{samples}{Numeric. How many boostrap samples (defaults to \code{500}).}

\item{penalty}{Character string. Which penalty should be used (defaults to \code{"atan"})?}

\item{ic}{Character string. Which information criterion should be used (defaults to \code{"bic"})?
The options include \code{aic}, \code{ebic} (ebic_gamma defaults to \code{0.5}; see details),
\code{ric}, or any of the generalized information criteria provided in section 5 of
\insertCite{kim2012consistent;textual}{GGMncv}. The options are \code{gic_1}
(i.e., \code{bic}) to \code{gic_6}.}

\item{gamma}{Numeric. Hyperparameter for the penalty function. Defaults to 3.7 (\code{SCAD}),
2 (\code{MCP}), 0.5 (\code{adapt}), and 0.01 otherwise with \code{select = "lambda"}.}

\item{lambda}{Numeric vector. Regularization parameter. Defaults to \code{NULL} that provides default
values with  \code{select = "lambda"} and  \code{sqrt(log(p)/n)} with
\code{select = "gamma"}.}

\item{n_lambda}{Numeric. The number of \mjseqn{\lambda}'s to be evaluated. Defaults to 50.
This is disregarded if custom values are provided in \code{lambda}.}

\item{n_gamma}{Numeric. The number of \mjseqn{\gamma}'s to be evaluated. Defaults to 50.
This is disregarded if custom values are provided in \code{lambda}.}

\item{unreg}{Logical. Should the models be refitted (or unregularized) with maximum likelihood
(defaults to \code{FALSE})? Setting to \code{TRUE} results in the approach of
\insertCite{Foygel2010;textual}{GGMncv}, but with the regularization path obtained from
nonconvex regularization, as opposed to the \mjseqn{\ell_1}-penalty.}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}

\item{...}{Additional arguments. Currently gamma in EBIC (\code{ic = "ebic"}) can be set
with \code{ebic_gamma = 1}.}
}
\value{
An object of class \code{eip}
}
\description{
\loadmathjax
Compute edge inclusion 'probabilities' with a non-parametric bootstrap.
}
\examples{
# data
Y <- GGMncv::ptsd[,1:10]

# compute eip's
boot_samps <- boot_eip(Y, samples  = 10)
}
