#' GGMncv:  Gaussian Graphical Models with Nonconvex Regularization
#'
#' @description
#' \loadmathjax
#' The primary goal of GGMncv is to provide non-convex penalties for estimating
#' Gaussian graphical models. These are known to overcome the various limitations
#' of lasso (least absolute shrinkage "screening" operator),
#' including inconsistent model selection \insertCite{zhao2006model}{GGMncv},
#' biased estimates \insertCite{zhang2010nearly}{GGMncv}, and a high
#' false positive rate
#' \insertCite{@see for example @williams2020back;@williams2019nonregularized}{GGMncv}
#'
#'
#' Several of the penalties are (continuous) approximations to the
#' \mjseqn{\ell_0} penalty, that is, best subset selection. However, the solution
#' does not require enumerating all possible models which results in a computationally
#' efficient solution.
#'
#' \strong{L0 Approximations}
#'
#' \itemize{
#'
#' \item Atan: \code{penalty = "atan"} \insertCite{wang2016variable}{GGMncv}.
#'  This is currently the default.
#'
#' \item Seamless \mjseqn{\ell_0}: \code{penalty = "selo"} \insertCite{dicker2013variable}{GGMncv}.
#'
#' \item Exponential: \code{penalty = "exp"}  \insertCite{wang2018variable}{GGMncv}
#'
#' \item Log: \code{penalty = "log"} \insertCite{mazumder2011sparsenet}{GGMncv}.
#'
#' \item Sica: \code{penalty = "sica"}  \insertCite{lv2009unified}{GGMncv}
#'
#' }
#'
#' \strong{Additional penalties}:
#'
#' \itemize{
#'
#' \item SCAD: \code{penalty = "scad"}  \insertCite{fan2001variable}{GGMncv}.
#'
#' \item MCP: \code{penalty = "mcp"} \insertCite{zhang2010nearly}{GGMncv}.
#'
#' \item Adaptive lasso: \code{penalty = "adapt"} \insertCite{zou2006adaptive}{GGMncv}.
#'
#' \item Lasso:  \code{penalty = "lasso"}  \insertCite{tibshirani1996regression}{GGMncv}.
#'
#' }
#'
#' \strong{Citing GGMncv}
#'
#' It is important to note that GGMncv merely provides a software implementation
#' of other researchers work. There are no methodological innovations,
#' although this is the most comprehensive R package for estimating GGMs
#' with non-convex penalties. Hence, in addition to citing the
#' package \code{citation("GGMncv")}, it is important to give credit to the primary
#' sources. The references are provided above and in \code{\link{ggmncv}}.
#'
#' Further, a survey (or review) of these penalties can be found in
#' \insertCite{williams2020beyond;textual}{GGMncv}.
#'
#' @references
#' \insertAllCited{}
#'
#' @docType package
#'
#' @name GGMncv-package
NULL
