% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_GGoutlieR.R
\name{plot_ggoutlier}
\alias{plot_ggoutlier}
\title{Visualize GGoutlieR results on a geographical map}
\usage{
plot_ggoutlier(
  ggoutlier_res,
  geo_coord,
  anc_coef = NULL,
  gen_coord = NULL,
  pie_color = NULL,
  map_color = "black",
  p_thres = NULL,
  color_res = 10,
  dot_cex = 0.4,
  map_type = c("geographic_knn", "genetic_knn", "both"),
  select_xlim = c(-180, 180),
  select_ylim = c(-90, 90),
  plot_xlim = NULL,
  plot_ylim = NULL,
  only_edges_in_xylim = TRUE,
  pie_r_scale = 1,
  red_alpha = 0.8,
  map_resolution = "low",
  show_knn_pie = FALSE,
  show_col_bar = TRUE,
  which_sample = NULL,
  add_benchmark_graph = TRUE,
  vertical_plots = TRUE,
  adjust_p_value_projection = FALSE
)
}
\arguments{
\item{ggoutlier_res}{output of `ggoutlier`}

\item{geo_coord}{matrix or data.frame with two columns. The first column is longitude and the second one is latitude.}

\item{anc_coef}{matrix. A matrix of ancestry coefficients with samples ordered by rows. Ancestry coefficients are used to make pie charts on a geographical map. This argument is optional.}

\item{gen_coord}{matrix. A matrix of "coordinates in a genetic space". It should be identical to the `gen_coord` used for running `ggoutlier`}

\item{pie_color}{string. Colors of pie charts. colors are automatically assigned if `pie_color = NULL` (which is the default). This argument is optional.}

\item{map_color}{string. Colors of map contours. The default is `map_color = "black"`}

\item{p_thres}{numeric. A value of significant level. Only outliers (p values less than `p_thres`) are mapped on a geographical map if `p_thres` is provided (the default is `NULL`). This argument is optional.}

\item{color_res}{integer. The resolution of color scale.}

\item{dot_cex}{numeric. The size of dots denoting the positions of samples on a geographical map.}

\item{map_type}{string. The type of plot to draw. It can be `"geographic_knn"`, `"genetic_knn"` and `"both"`.}

\item{select_xlim}{vector. Values controlling longitude boundaries of a window to select outliers to present on a geographical map. The default is `select_xlim = c(-180,180)`.}

\item{select_ylim}{vector. Values controlling latitude boundaries of a window to select outliers to present on a geographical map. The default is `select_ylim = c(-90,90)`.}

\item{plot_xlim}{vector. Values controlling longitude boundaries of a map.}

\item{plot_ylim}{vector. Values controlling latitude boundaries of a map.}

\item{only_edges_in_xylim}{logic. only the edges with starting points within the given `select_xlim` and `select_ylim` will display on a geographical map. If `FALSE`, the edges out of the given boundaries will be removed from your plot. The default is `TRUE`.}

\item{pie_r_scale}{numeric. A scale controlling the radius of pie charts}

\item{red_alpha}{numeric. A value controlling the transparency of red lines. the default is 0.8}

\item{map_resolution}{string. The resolution of the geographical map. See details in the manual of `rworldmap::getMap()`}

\item{show_knn_pie}{logic. If `TRUE`, the ancestry coefficients of K nearest neighbors of significant samples will display on the map. The default is `FALSE`.}

\item{show_col_bar}{logic. If `TRUE`, a color key will be added to the output graph.}

\item{which_sample}{a string vector of sample ID(s). If users want to only show specific sample(s)}

\item{add_benchmark_graph}{logic. If `TRUE`, a benchmark graph with only pie charts of ancestry coefficients for comparison with the outlier graph.}

\item{vertical_plots}{logic. If `TRUE`, a benchmark graph and outlier graph will be combined in a vertical direction.}

\item{adjust_p_value_projection}{logic. If `TRUE`, the function will perform KNN prediction by forcing K=1 and compute new p-values for visualization.}
}
\value{
a geographical map with colored lines showing sample pairs with unusual geo-genetic associations.
}
\description{
Visualize geo-genetic patterns of outliers with their K nearest neighbors
}
\details{
Red links on the map denote individual pairs that are genetically similar but geographically remote.
The color depth and thickness of red links are proportional to -log10(p) based on the empirical Gamma distribution obtained from `detect_outlier_in_GeneticSpace`.
Blue links on the map denote individual pairs that are genetically different but geographically close.
The color depth and thickness of blue links are proportional to -log10(p) based on the empirical Gamma distribution obtained from `detect_outlier_in_GeoSpace`
}
\examples{
library(GGoutlieR)
data("ipk_anc_coef") # get ancestry coefficients
data("ipk_geo_coord") # get geographical coordinates
data(ggoutlier_example) # get an example output of ggoutlier
plot_ggoutlier(ggoutlier_res = ggoutlier_example,
               gen_coord = ipk_anc_coef,
               geo_coord = ipk_geo_coord,
               p_thres = 0.025,
               map_type = "both",
               select_xlim = c(-20,140),
               select_ylim = c(10,62),
               plot_xlim = c(-20,140),
               plot_ylim = c(10,62),
               pie_r_scale = 1.2,
               map_resolution = "coarse")

}
