% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_regions.R
\name{GIFT_regions}
\alias{GIFT_regions}
\title{Metadata for GIFT regions}
\usage{
GIFT_regions(
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A data frame with 7 columns.
}
\description{
Retrieves miscellaneous information for GIFT regions.
}
\details{
Here is the detail of each column:

\emph{entity_ID} - Identification number of GIFT polygons\cr
\emph{geo_entity} - Name of GIFT polygons\cr
\emph{suit_geo} - Whether the polygon is suitable\cr
\emph{entity_class} - Class of the polygon\cr
\emph{entity_type} - Type of the polygon\cr
\emph{TDWG_lvl3_ID} - Whether the polygon is a TDWG region (see
https://www.tdwg.org/)\cr
\emph{country} - Whether the polygon is a country
}
\examples{
\donttest{
ex <- GIFT_regions()
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_env_meta_misc]{GIFT_env_meta_misc()}}
}
