% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMcat2.R
\name{glmcat}
\alias{glmcat}
\title{Generalized linear models for categorical responses}
\usage{
glmcat(
  formula,
  data,
  ratio = c("reference", "cumulative", "sequential", "adjacent"),
  cdf = list(),
  parallel = NA,
  categories_order = NA,
  ref_category = NA,
  threshold = c("standard", "symmetric", "equidistant"),
  control = list(),
  normalization = 1,
  na.action = "na.omit",
  find_nu = FALSE,
  ...
)
}
\arguments{
\item{formula}{formula a symbolic description of the model to be fit. An expression of the form `y ~ predictors` is interpreted as a specification that the response `y` is modeled by a linear predictor specified by `predictors`.}

\item{data}{a dataframe object in R, with the dependent variable as a factor.}

\item{ratio}{a string indicating the ratio (equivalently to the family) options are: reference, adjacent, cumulative and sequential.  It is mandatory for the user to specify the desired ratio option as there is no default value.}

\item{cdf}{The inverse distribution function to be used as part of the link function.
- If the distribution has no parameters to specify, then it should be entered as a string indicating the name, e.g., `cdf = "normal"`. The default value is `cdf = "logistic"`.
- If there are parameters to specify, then a list must be entered. For example, for Student's distribution: `cdf = list("student", df=2)`. For the non-central distribution of Student: `cdf = list("noncentralt", df=2, mu=1)`.}

\item{parallel}{a character vector indicating the name of the variables with a parallel effect. If a variable is categorical, specify the name and the level of the variable as a string, e.g., `"namelevel"`.}

\item{categories_order}{a character vector indicating the incremental order of the categories, e.g., `c("a", "b", "c")` for `a < b < c`. Alphabetical order is assumed by default. Order is relevant for adjacent, cumulative, and sequential ratio.}

\item{ref_category}{a string indicating the reference category. This option is suitable for models with reference ratio.}

\item{threshold}{a restriction to impose on the thresholds. Options are: `standard`, `equidistant`, or `symmetric`. This is valid only for the cumulative ratio.}

\item{control}{a list of control parameters for the estimation algorithm.
- `maxit`: The maximum number of iterations for the Fisher scoring algorithm.
- `epsilon`: A double to change the convergence criterion of GLMcat models.
- `beta_init`: An appropriately sized vector for the initial iteration of the algorithm.}

\item{normalization}{the quantile to use for the normalization of the estimated coefficients when the logistic distribution is used as the base cumulative distribution function.}

\item{na.action}{an argument to handle missing data. Available options are `na.omit`, `na.fail`, and `na.exclude`. It does not include the `na.pass` option.}

\item{find_nu}{a logical argument to indicate whether the user intends to utilize the Student CDF and seeks an optimization algorithm to identify an optimal degrees of freedom setting for the model.}

\item{...}{additional arguments.
\code{Note:} If the 'reference' ratio is used, you'll get a warning if the variable is an ordered factor.
\code{Note:} If any other 'radio' is used, it will issue a warning if the response is not ordered, and the variables order will default to the alphanumeric natural order.}
}
\description{
Estimate generalized linear models implemented under the unified
specification ( ratio,cdf,Z) where \code{ratio} represents the ratio of probabilities
(reference, cumulative, adjacent, or sequential), \code{cdf} the cumulative distribution function
for the linkage, and Z the design matrix which must be specified through the \code{parallel}
and the \code{threshold} arguments.
}
\details{
Fitting models for categorical responses

This function fits generalized linear models for categorical responses using the unified specification framework introduced by Peyhardi, Trottier, and Guédon (2015).
}
\examples{
data(DisturbedDreams)
ref_log_com <- glmcat(formula = Level ~ Age, data = DisturbedDreams,
    ref_category = "Very.severe",
    cdf = "logistic", ratio = "reference")
}
\references{
Peyhardi J, Trottier C, Guédon Y (2015). “A new specification of generalized linear models
 for categorical responses.” \emph{Biometrika}, 102(4), 889–906. doi:10.1093/biomet/asv042.
}
\seealso{
\code{\link{summary.glmcat}}
}
\keyword{categorical}
\keyword{generalized}
\keyword{linear}
\keyword{model}
\keyword{variables}
