% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anecdotal.R
\name{anecdotal}
\alias{anecdotal}
\title{Anecdotal model}
\usage{
anecdotal(
  RESOURCES = NULL,
  LAND = NULL,
  PARAS = NULL,
  AGENTS = NULL,
  res_type = 1,
  samp_age = 1,
  agent_type = 0,
  type_cat = 1,
  move_agents = FALSE,
  model = "IBM"
)
}
\arguments{
\item{RESOURCES}{The resources array produced by the resource function within GMSE}

\item{LAND}{The landscape array on which interactions between resources and agents occur}

\item{PARAS}{The vector of parameters that hold global and dynamic parameter values used by GMSE}

\item{AGENTS}{The array of agents produced in the main gmse() function}

\item{res_type}{The type of resources being observed (default = 1)}

\item{samp_age}{Minimum age of the resource being sampled (default = 1)}

\item{agent_type}{The type of agent doing the observing (default = 0)}

\item{type_cat}{The category of agent type (first 4 columns) doing observing; this will almost always be 1, so type 0 agents (managers, of which there is always one by default) will be affected}

\item{move_agents}{Whether or not agents are moved during the run of anecodtal}

\item{model}{The type of model being applied (Currently only individual-based
-- i.e., 'agent-based' -- models are allowed)}
}
\value{
The anecdotal function outputs an R list that includes two separate arrays, including (1) a new AGENTS array and (3) a new PARAS array, each of which might be affected by the anecdotal function.  The new arrays can then be read back into the broader GMSE function, thereby affecting the input into the management, user, resource, and observation models.
}
\description{
A simulation of how many resources of a particular type are in the vicinity 
of each agent -- this produces a kind of anecdotal evidence for each agent 
around their circle of view. It also potentially moves the agents during a 
time step.
}
\examples{
\dontrun{
AGENTS_NEW <- anecdotal(RESOURCES = RESOURCES, LAND = LANDSCAPE_r, 
PARAS = paras, AGENTS = AGENTS, res_type = 1, samp_age = rma, agent_type = -1,
type_cat = 1, move_agents = mva);
}
}
