% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialise.R
\name{make_resource}
\alias{make_resource}
\title{Resource initialisation}
\usage{
make_resource(
  model = "IBM",
  resource_quantity = 100,
  resource_types = 1,
  rows = 100,
  cols = 100,
  move = 1,
  rm_pr = 0,
  lambda = 0,
  consumption_rate = 0.1,
  max_age = 5,
  times_feeding = 1
)
}
\arguments{
\item{model}{The type of model being applied (Currently only individual-based
-- i.e., 'agent-based' -- models are allowed)}

\item{resource_quantity}{The total number of resources being initialised (e.g., the population size of the resource at the first time step)}

\item{resource_types}{The number of resource types that exist. Currently, only one resource type is recommended, but future versions of GMSE will include multiple resource types if requested}

\item{rows}{The number of rows (y-axis) on the simulated landscape; resources are randomly placed somewhere on the landscape array}

\item{cols}{The number of columns (x-axis) on the simulated landscape; resources are randomly placed somewhere on the landscape array}

\item{move}{This parameter affects the movement of resources each time step. There are multiple types of movement (see res_move_type in the gmse function), but this parameter determines the distance in cells that a resource will move}

\item{rm_pr}{This parameter sets the baseline probability of resource removal (death) per time step; this probability can be affected by user actions or carrying capacity, so a probability of zero does not ensure that resources will necessarily persist until the end of the simulation}

\item{lambda}{This is the parameter for Poisson random sampling affecting birthrate; each resource gives birth to Poisson(lambda) offspring in the resource model}

\item{consumption_rate}{Rate at which resource consumes crops on landscape; consumption affects the landscape by decreasing values on the landscape array (which may, e.g., be interpreted as crop production being decreased), and might also affect resource demographic parameters depending on other global options set in GMSE}

\item{max_age}{Maximum age allowed for a resource to be (in time steps)}

\item{times_feeding}{Number of times a resource moves on a landscape during a single time step in search of food}
}
\value{
the_resources Initialised data frame of resources being modelled
}
\description{
Initialise the resources of the G-MSE model.
}
\examples{
resource <- make_resource(model = "IBM", resource_quantity = 100, 
resource_types = 1, rows = 100, cols = 100, move = 1, rm_pr = 0, lambda = 0, 
consumption_rate = 0.5, max_age = 5);
}
