% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goedit.R
\name{prioritizedGOTerms}
\alias{prioritizedGOTerms}
\title{prioritization of a lists of GO-terms}
\usage{
prioritizedGOTerms(lst = NULL, organism = NULL, sp = TRUE, domain = "BP")
}
\arguments{
\item{lst}{The GO ids we want to prioritize}

\item{organism}{If organism is given then only the gene association GO-terms of that organism are considered during
the prioritization otherwise, all the (non-retired) GO-terms from a particular ontology
are used in the ranking.}

\item{sp}{If the argument "sp" is TRUE, only shortest paths are used, otherwise all paths}

\item{domain}{Ontology of the GO-terms. The default is BP.}
}
\value{
A list containing the prioritize GO-terms, their ranking, original GO-terms and their GO-levels is given.
}
\description{
Given a vector of GO-terms, this function prioritizes the GO-terms by expoiting the structure of a DAG.
             Starting from the GO-term on the highest level and searching all the paths to the root node iteratively.
             If any GO-terms in the input
             vector are found along this path, these GO-terms are removed. This is because the GO-term at the end of a path
             is more specific than the GO-terms along the path. For an organism, the GO-terms of that organism are used for
             the prioritization. The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast", "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{

Terms <-c("GO:0000278", "GO:0006414","GO:0022403","GO:0006415","GO:0006614",
 "GO:0045047","GO:0022411","GO:0001775","GO:0046649","GO:045321")
prioritizedGOTerms(Terms, organism = "Human", sp=TRUE, domain = "BP")
}
