% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distanceMatrix}
\alias{distanceMatrix}
\alias{distMat}
\alias{distMatSq}
\alias{distMatLinear}
\alias{distMatLinearSq}
\title{Calculate generalised distances}
\usage{
distMat(input, inputNew, A, power)

distMatSq(input, A, power)

distMatLinear(input, inputNew, A)

distMatLinearSq(input, A)
}
\arguments{
\item{input}{Vector of the input coordinate t}

\item{inputNew}{Vector of the input coordinate t'}

\item{A}{Anisotropy matrix A}

\item{power}{Power value p}
}
\value{
A matrix
}
\description{
Calculate the generalised distance between vectors t and t'
using an anisotropy matrix A.

\itemize{
\item \code{distMat} and \code{distMatSq} calculate:
\deqn{ [(t - t')^{p/2}]^T A  (t - t')^{p/2}  }
\item \code{distMatLinear} and \code{distMatLinearSq} calculate:
\deqn{ t^T A t' }
}
}
\details{
The \code{distMatSq} and \code{distMatLinearSq} functions are 
used when input vectors t and t' are identical, returning a symmetric matrix. \cr \cr
When \code{distMat} and \code{distMatSq} functions are used in 
powered exponential kernels, power=1 gives the exponential kernel and 
power=2 gives the squared exponential one. \cr \cr
\code{distMatLinear} and \code{distMatLinearSq} functions are used in the 
linear covariance kernel.
}
