#' @name GPrank-package
#' @docType package
#' @title GPrank - Gaussian Process ranking of multiple time series
#' @description GPrank package implements our Gaussian-process-based ranking method,
#' which can be used to rank multiple time series according to their temporal activity
#' levels. GPrank incorporates available variance information on the observations
#' into the GP models and achieves a higher performance than the standard GP-based
#' ranking methods. 
#'
#' @details
#' \tabular{ll}{
#' Package: \tab GPrank\cr
#' Type: \tab Package\cr
#' Version: \tab 0.1.1\cr
#' Date: \tab 2016-10-27\cr
#' License: \tab MIT\cr
#' }
#' Details regarding the usage of the package can be found in the vignette.
#'
#' @author Hande Topa, Antti Honkela
#'
#' Maintainer: Hande Topa \email{hande.topa@@helsinki.fi} 
#'
#' @references
#' Hande Topa, Agnes Jonas, Robert Kofler, Carolin Kosiol, Antti Honkela.
#' Gaussian process test for high-throughput sequencing time series: application to experimental evolution.
#' \emph{Bioinformatics} 31(11):1762-1770, \bold{2015}.
#'
#' Hande Topa, Antti Honkela. 
#' Analysis of differential splicing suggests different modes of short-term splicing regulation.
#' \emph{Bioinformatics} 32(12):i147-i155, \bold{2016}.
#'
#' @keywords package
#'

NULL
