% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_wrappers.R
\name{vecchia_estimate}
\alias{vecchia_estimate}
\title{estimate mean and covariance parameters using Vecchia}
\usage{
vecchia_estimate(data, locs, X, m = 20, covmodel = "matern", theta.ini,
  output.level = 1, ...)
}
\arguments{
\item{data}{data vector of length n}

\item{locs}{n x d matrix of spatial locations}

\item{X}{n x p matrix of trend covariates. default is vector of ones (constant trend).
set to NULL if data are already detrended}

\item{m}{number of neighbors for vecchia approximation. default is 20}

\item{covmodel}{covariance model. default is Matern.
see \code{\link{vecchia_likelihood}} for details.}

\item{theta.ini}{initial values of covariance parameters. nugget variance must be last.}

\item{output.level}{passed on to trace in the \code{stats::optim} function}

\item{...}{additional input parameters for \code{\link{vecchia_specify}}}
}
\value{
object containing detrended data z, trend coefficients beta.hat,
   covariance parameters theta.hat, and other quantities necessary for prediction
}
\description{
estimate mean and covariance parameters using Vecchia
}
\examples{
\donttest{
n=10^2; locs=cbind(runif(n),runif(n))
covparms=c(1,.1,.5); nuggets=rep(.1,n)
Sigma=exp(-fields::rdist(locs)/covparms[2])+diag(nuggets)
z=as.numeric(t(chol(Sigma))\%*\%rnorm(n));
data=z+1
vecchia.est=vecchia_estimate(data,locs,theta.ini=c(covparms,nuggets[1]))
}
}
