% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen.R
\name{green_shares}
\alias{green_shares}
\title{Geospatial Regression Equation parallel execution returning the source
apportionment}
\usage{
green_shares(catch_data, annual_data, alpha_p, alpha_l, sd_coef, loc_years)
}
\arguments{
\item{catch_data}{data frame. Definition of the topological sequence of
catchments.}

\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{alpha_p}{numeric. First model parameter, the basin retention
coefficient.}

\item{alpha_l}{numeric. Second model parameter, the river retention
coefficient.}

\item{sd_coef}{numeric. Third model parameter, fraction of domestic diffuse
sources that reaches the stream network.}

\item{loc_years}{integer. Years in which the model should be executed.}
}
\value{
One object, a data frame with the nutrient load by each source for
all catchments in the Basin
}
\description{
Run GREEN model with selected parameter set and returns the
nutrient load by each source for all catchments in the Basin.
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
# the parameter to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2
# year in which the model should be executed
loc_years <- 1990:2018
# Computing the source apportionment
basin_loads_s <- green_shares(catch_data_TN, annual_data_TN, alpha_p, alpha_l,
sd_coef, loc_years)
}

}
