% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMBM.R
\name{rMBM}
\alias{rMBM}
\title{Simulate datasets from  the multipartite block  model (MBM).}
\usage{
rMBM(
  v_NQ,
  E,
  typeInter,
  v_distrib,
  list_pi,
  list_theta,
  namesFG = NULL,
  keepClassif = FALSE,
  seed = NULL
)
}
\arguments{
\item{v_NQ}{: number of individual in each Functional Group (FG)}

\item{E}{: define the architecture of the Multipartite.}

\item{typeInter}{: type of interaction in each network: undirected adjacency (adj), directed adjacency (diradj) or incidence (inc).  (vector of size equal to nrow(E) )}

\item{v_distrib}{: vector of the distributions: 'bernoulli', 'poisson', 'gaussian', 'ZIgaussian' (for Zero inflated gaussian) or 'laplace'  ( vector of size equal to nrow(E) )}

\item{list_pi}{: parameters of the blocks distribution}

\item{list_theta}{: parameters of the interactions distribution. For Bernoulli a probability, for Poisson positive real number, for Gaussian a list specifying mean and var (plus p0 for ZIgaussian), for Laplace a list with location and scale}

\item{namesFG}{: names of the FG.  (default value  = NULL, then the functional groups are labelled FG1, FG2, etc)}

\item{keepClassif}{: equal to TRUE if you want to keep the simulated blocks/classification (default value  = FALSE).}

\item{seed}{: set the seed for the random simulation (default value  = NULL)}
}
\value{
A list of lists containing the networks (list_net) and if keepClassif = TRUE the classifications (classif)
Each element of  list_net corresponds to a network : each network is a list containing  the matrix (mat) , the type of network(diradj, adj, inc), the functional group in row (rowFG) and the functional group in columns (colFG)
}
\description{
\code{rMBM} simulates a collection of networks involving common functional groups of entities. The networks may be directed, undirected or bipartite. The emission distribution of the edges may be Bernoulli, Poisson, Gaussian, Zero-Inflated Gaussian, or Laplace. See the vignette for more information about the model.
}
\examples{
namesFG <- c('A','B','C')
list_pi = list(c(0.16 ,0.40 ,0.44),c(0.3,0.7),c(0.5,0.5))
E  <-  rbind(c(1,2),c(2,3),c(1,1))
typeInter <- c( "inc","inc", "adj")
v_distrib <- c('ZIgaussian','bernoulli','poisson')
list_theta <- list()
list_theta[[1]] <- list()
list_theta[[1]]$mean  <- matrix(c(6.1, 8.9, 6.6, 9.8, 2.6, 1.0), 3, 2)
list_theta[[1]]$var  <-  matrix(c(1.6, 1.6, 1.8, 1.7 ,2.3, 1.5),3, 2)
list_theta[[1]]$p0  <-  matrix(c(0.4, 0.1, 0.6, 0.5 , 0.2, 0),3, 2)
list_theta[[2]] <- matrix(c(0.7,1.0, 0.4, 0.6),2, 2)
m3 <- matrix(c(2.5, 2.6 ,2.2 ,2.2, 2.7 ,3.0 ,3.6, 3.5, 3.3),3,3 )
list_theta[[3]] <- (m3 + t(m3))/2
dataSim <- rMBM(v_NQ = c(100,50,40) , E = E , typeInter = typeInter,
                v_distrib = v_distrib, list_pi = list_pi,
                list_theta = list_theta, namesFG)
list_net <- dataSim$list_Net
classifTrue <- dataSim$classif
}
