/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import org.itadaki.bzip2.BZip2DivSufSort;
import org.itadaki.bzip2.BZip2HuffmanStageEncoder;
import org.itadaki.bzip2.BitOutputStream;
import org.itadaki.bzip2.CRC32;

public class BZip2BlockCompressor {
    private static final int RLE_NOT_A_VALUE = 65535;
    private final BitOutputStream bitOutputStream;
    private final CRC32 crc = new CRC32();
    private final byte[] block;
    private int blockLength = 0;
    private final int blockLengthLimit;
    private final boolean[] blockValuesPresent = new boolean[256];
    private final int[] bwtBlock;
    private int rleCurrentValue = 65535;
    private int rleLength = 0;

    private void writeRun(int value, int runLength) {
        int blockLength = this.blockLength;
        byte[] block = this.block;
        this.blockValuesPresent[value] = true;
        this.crc.updateCRC(value, runLength);
        byte byteValue = (byte)value;
        switch (runLength) {
            case 1: {
                block[blockLength] = byteValue;
                this.blockLength = blockLength + 1;
                break;
            }
            case 2: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                this.blockLength = blockLength + 2;
                break;
            }
            case 3: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                block[blockLength + 2] = byteValue;
                this.blockLength = blockLength + 3;
                break;
            }
            default: {
                this.blockValuesPresent[runLength -= 4] = true;
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                block[blockLength + 2] = byteValue;
                block[blockLength + 3] = byteValue;
                block[blockLength + 4] = (byte)runLength;
                this.blockLength = blockLength + 5;
            }
        }
    }

    public boolean write(int value) {
        if (this.blockLength > this.blockLengthLimit) {
            return false;
        }
        int rleCurrentValue = this.rleCurrentValue;
        int rleLength = this.rleLength;
        if (rleCurrentValue == 65535) {
            this.rleCurrentValue = value;
            this.rleLength = 1;
        } else if (rleCurrentValue == value) {
            if (rleLength == 254) {
                this.writeRun(rleCurrentValue & 0xFF, 255);
                this.rleCurrentValue = 65535;
            } else {
                this.rleLength = rleLength + 1;
            }
        } else {
            this.writeRun(rleCurrentValue & 0xFF, rleLength);
            this.rleLength = 1;
            this.rleCurrentValue = value;
        }
        return true;
    }

    public int write(byte[] data, int offset, int length) {
        int written = 0;
        while (length-- > 0) {
            if (!this.write(data[offset++])) break;
            ++written;
        }
        return written;
    }

    public void close() throws IOException {
        if (this.rleCurrentValue != 65535 && this.rleLength > 0) {
            this.writeRun(this.rleCurrentValue & 0xFF, this.rleLength);
        }
        this.block[this.blockLength] = this.block[0];
        BZip2DivSufSort divSufSort = new BZip2DivSufSort(this.block, this.bwtBlock, this.blockLength);
        int origPtr = divSufSort.bwt();
        this.bitOutputStream.writeBits(24, 3227993);
        this.bitOutputStream.writeBits(24, 2511705);
        this.bitOutputStream.writeInteger(this.crc.getCRC());
        this.bitOutputStream.writeBoolean(false);
        this.bitOutputStream.writeBits(24, origPtr);
        BZip2HuffmanStageEncoder huffmanEncoder = new BZip2HuffmanStageEncoder(this.bitOutputStream, this.blockValuesPresent, this.bwtBlock, this.blockLength);
        huffmanEncoder.encode();
    }

    public boolean isEmpty() {
        return this.blockLength == 0 && this.rleLength == 0;
    }

    public int getCRC() {
        return this.crc.getCRC();
    }

    public BZip2BlockCompressor(BitOutputStream bitOutputStream, int blockSize) {
        this.bitOutputStream = bitOutputStream;
        this.block = new byte[blockSize];
        this.bwtBlock = new int[blockSize];
        this.blockLengthLimit = blockSize - 5;
    }
}

