/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class PositionTrackingInputStream
extends InputStream {
    private InputStream wrappedStream;
    private AtomicLong currentPosition;
    private AtomicLong markedPosition;

    public PositionTrackingInputStream(InputStream wrappedStream) {
        this.wrappedStream = wrappedStream;
        this.currentPosition = new AtomicLong();
        this.markedPosition = new AtomicLong();
    }

    public int available() throws IOException {
        return this.wrappedStream.available();
    }

    public void close() throws IOException {
        this.wrappedStream.close();
    }

    public void mark(int readlimit) {
        this.wrappedStream.mark(readlimit);
        this.markedPosition.set(this.currentPosition.get());
    }

    public boolean markSupported() {
        return this.wrappedStream.markSupported();
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int read = this.wrappedStream.read(arg0, arg1, arg2);
        if (read > 0) {
            this.currentPosition.addAndGet(read);
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.wrappedStream.read(b);
        if (read > 0) {
            this.currentPosition.addAndGet(read);
        }
        return read;
    }

    public void reset() throws IOException {
        this.wrappedStream.reset();
        this.currentPosition.set(this.markedPosition.get());
    }

    public long skip(long arg0) throws IOException {
        long read = this.wrappedStream.skip(arg0);
        if (read > 0L) {
            this.currentPosition.addAndGet(read);
        }
        return read;
    }

    public int read() throws IOException {
        int read = this.wrappedStream.read();
        if (read >= 0) {
            this.currentPosition.incrementAndGet();
        }
        return read;
    }

    public long getPosition() {
        return this.currentPosition.get();
    }
}

