% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_fastqc.R
\name{run_fastqc}
\alias{run_fastqc}
\title{QC report for each fastq files using FastQC}
\usage{
run_fastqc(destdir, fastq_dir, n_thread)
}
\arguments{
\item{destdir}{directory where all the results will be saved.}

\item{fastq_dir}{directory of the fastq files.}

\item{n_thread}{number of cores to use.}
}
\value{
HTML report of the fastq files under fastqc directory.
}
\description{
\code{run_fastqc} HTML report of each fastq files using FastQC.
You need to install FastQC from
\url{https://www.bioinformatics.babraham.ac.uk/projects/fastqc/}
}
\examples{

fastq_dir=system.file("extdata","", package="GREP2")
\donttest{
run_fastqc(destdir=tempdir(),fastq_dir=fastq_dir,
n_thread=2)
}

}
