% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_gridCopula.R
\name{estimate.gridCopula}
\alias{estimate.gridCopula}
\title{Estimates the parameters of a grid type copula}
\usage{
estimate.gridCopula(
  U,
  k = NULL,
  m = NULL,
  method = "ml",
  D.ini = NULL,
  criterion = "AIC"
)
}
\arguments{
\item{U}{a matrix of size nx2 with the observed values.}

\item{k}{positive integer indicating the number of subintervals for the U2 variable.}

\item{m}{positive integer indicating the number of subintervals for the U1 variable.}

\item{method}{Method that uses, least squares "ls" or maximum likelihood "ml", by default "ml".}

\item{D.ini}{a matrix with the initial values for the density copula.package: the name of the package for numerical optimization.}

\item{criterion}{If the values of k i m are not specified, they will be obtained by the "AIC" or "BIC" criteria, by default "AIC".}
}
\value{
Returns a list with a matrix with the density over the grid,
a matrix with the quantity of data over the grid, the number of subintervals for the U2 variable,
the number of subintervals for the U1 variable.
}
\description{
This function estimates grid type copulas by one of the following methods: maximum likelihood or least squares (See reference).
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 5
m <- 4
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
print(copula.grid$Density)
}
\references{
{@misc{https://doi.org/10.48550/arxiv.2010.15709,
doi = {10.48550/ARXIV.2010.15709},
url = {https://arxiv.org/abs/2010.15709},
author = {Pfeifer, Dietmar and Strassburger, Doreen and Philipps, Joerg},
keywords = {Methodology (stat.ME), Risk Management (q-fin.RM), FOS: Computer and information sciences, FOS: Computer and information sciences, FOS: Economics and business, FOS: Economics and business, 62H05, 62H12, 62H17, 11K45},
title = {Modelling and simulation of dependence structures in nonlife insurance with Bernstein copulas},
publisher = {arXiv},
year = {2020},
copyright = {arXiv.org perpetual, non-exclusive license}
}
}
}
