% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alex.pathway.R
\name{alex.pathway}
\alias{alex.pathway}
\title{Associate Lesions with Expression Data on the Pathway Level}
\usage{
alex.pathway(alex.data, lsn.data, pathways, selected.pathway)
}
\arguments{
\item{alex.data}{output of the alex.prep.lsn.expr function. It's a list of three data tables that include "row.mtch", "alex.expr" with expression data, "alex.lsn" with lesion data. Rows of alex.expr, and "alex.lsn" matrices are ordered by gene ensembl IDs and columns are ordered by patient ID.}

\item{lsn.data}{Lesion data in a GRIN compatible format. data.frame should has five columns that include "ID" with patient ID, "chrom" which is the chromosome on which the lesion is located, "loc.start" which is the lesion start position, "loc.end" the lesion end position and "lsn.type" which is the lesion type for example gain, loss, mutation, fusion, etc...}

\item{pathways}{data.frame with three columns "gene.name" that has gene symbols, "ensembl.id" with gene ensembl ID and "pathway" that has the pathway name.}

\item{selected.pathway}{The pathway of interest.}
}
\value{
Function will return two panels figure of lesion and expression data of ordered subjects based on the computed distances of lesions in all genes assigned to the pathway of interest. The function will also return:
\item{ordered.path.data}{data.frame with lesion and expression data of the pathway genes ordered based on the hiearchial clustering analysis (same order of the subjects in the lesion and expression panels of the figure).}
}
\description{
Function compute the distance between subjects in the dataset based on the lesions that affect different genes assigned to the pathway of interest and return two panels of lesion and expression data of ordered subjects based on the computed distances.
}
\details{
Function compute the distance between subjects in th dataset based on lesions affecting different genes assigned to the pathway of interest and return two panels of lesion and expression data of ordered subjects based on the computed distances. Function also return a data.frame with lesion and expression data of the pathway genes ordered based on the hierarchical clustering analysis (same order of the subjects in the lesion and expression panels of the figure).
}
\examples{
data(expr.data)
data(lesion.data)
data(hg19.gene.annotation)
data(pathways)

# prepare expression, lesion data and return the set of genes with both types of data available
# ordered by gene IDs in rows and patient IDs in columns:
alex.data=alex.prep.lsn.expr(expr.data, lesion.data,
                             hg19.gene.annotation, min.expr=5,
                             min.pts.lsn=5)

# use lesions in all genes assigned to the jak_pathway as an example pathway:
alex.path=alex.pathway(alex.data, lesion.data, pathways, "Jak_Pathway")
# extract expression and lesion data (same subjects order in the figure)
alex.path
}
\seealso{
\code{\link[=alex.prep.lsn.expr]{alex.prep.lsn.expr()}}, \code{\link[stats:hclust]{stats::hclust()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
