% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.gene.lsn.overlaps.R
\name{find.gene.lsn.overlaps}
\alias{find.gene.lsn.overlaps}
\title{Find Gene Lesion Overlaps}
\usage{
find.gene.lsn.overlaps(gl.data)
}
\arguments{
\item{gl.data}{a list of five data.frames that represent the output results of the prep.gene.lsn.data function.}
}
\value{
A list with the following components:
\item{lsn.data}{Input lesion data}
\item{gene.data}{Input gene annotation data}
\item{gene.lsn.data}{data.frame ordered by gene and lesions start position. Gene start position is coded as 1 in the cty column and gene end position is coded as 4. Lesion start position is coded as 2 in the cty column and lesion end position is coded as 3.}
\item{gene.lsn.hits}{data.frame on which each row represent a gene overlapped by a certain lesion. The data.frame has 11 columns that include "gene" with ensembl ID of the overlapped gene, "gene.chrom", "gene.loc.start" and "gene.loc.end" with data for the chromosome on which the gene is located, start and end positions of the gene. In addition, column "ID" has the ID of the patient with a lesion that overlapped this gene, "lsn.chrom", "lsn.loc.start", "lsn.loc.end" and "lsn.type" have data for the chromosome, lesion start, lesion end positions and the lesion type respectively.}
\item{gene.index}{data.frame that shows row start and row end for each chromosome in the gene.lsn.data table}
\item{lsn.index}{data.frame that shows row start and row end for each lesion in the gene.lsn.data table}
}
\description{
The function use the output of the prep.gene.lsn.data function to find lesion-gene overlaps.
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)

# prepare gene and lesion data for later computations:
prep.gene.lsn=prep.gene.lsn.data(lesion.data,
                                 hg19.gene.annotation)

# determine lesions that overlap each gene (locus):
gene.lsn.overlap=find.gene.lsn.overlaps(prep.gene.lsn)
}
\references{
Pounds, Stan, et al. (2013) A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=prep.gene.lsn.data]{prep.gene.lsn.data()}}
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
