% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{FSplot}
\alias{FSplot}
\title{Plot Factor score}
\usage{
FSplot(
  fit,
  type = "histogram",
  hist_bins = 20,
  fill_colour = "grey70",
  base_size = 16
)
}
\arguments{
\item{fit}{an object from \code{\link{runGRM}}}

\item{type}{a character indicating the type of plots
\itemize{
\item{\code{histogram}} Histogram plot
\item{\code{density}} Density plot
}}

\item{hist_bins}{a numeric indicating the number of bins for the histogram}

\item{fill_colour}{a character indicating the color (default = \code{grey70})}

\item{base_size}{a numeric indicating the base font size}
}
\value{
a \code{\link{ggplot}} object.
}
\description{
Plot Factor score
}
\details{
This makes either histogram or density plot for individual factor
 scores.
}
\examples{
grm_dt <- genData(eta = genTheta(nsample = 500, nfac = 1),
                 ipar = genIRTpar(nitem = 10, ncat = 3, nfac = 1))

fit <- runGRM(dat = grm_dt,
            lav.syntax = genLavSyn(dat = grm_dt, nfac = 1),
            estimator = "WL")
FSplot(fit, type = "histogram", hist_bins = 20, base_size = 16)

}
